$(document).ready(function(){
	// Initialisation
	layout.init();
	
	layout.selectLanguage();

	layout.cookie();
});
	
var layout = {
		
	init : function(){
		
		// On parcours tous les éléments copyright
		$('.copyrightContent').each(function(){
			// On récupère les tailless
			var padding = $(this).css('padding-top')+' '+$(this).css('padding-right')+' '+$(this).css('padding-bottom')+' '+$(this).css('padding-left');
			$(this).attr('data-width', $(this).find('p').width()); 
			$(this).attr('data-padding', padding); 

			// On cache les éléments copyright
			$(this).css('width','32px');
			$(this).css('padding','0px');
			$(this).css('opacity','0');
		});
		
		$('.copyrightContainer').css('opacity', 1);
		
		// Si on click sur un élément du body pour fermer un truc 
		$('#global').click(function(){
			if($('#footerTop .langueSelect ul').hasClass('opened')){
				$('#footerTop .langueSelect ul').stop().animate({
					opacity : 0
				}, 300, function(){
					$('#footerTop .langueSelect ul').css('display','none');
				});
				
				$('#footerTop .langueSelect ul').removeClass('opened');
				
				return false;
			}
		});
		
		// Click sur le lien retour en haut
		$('.backTop').click(function(event){

			// On scroll jusqu'au header
			$('html, body').animate({
				scrollTop : '0px'
			});
			
			return false;
		});
		
		// Click sur un élément copyright
		$('.pictoPhoto').click(function(){
			// On récupère la taille selon si c'est ouvert ou fermé
			var width = $(this).hasClass('opened') ? 32 : $(this).parent().find('.copyrightContent').data('width');
			var padding = $(this).hasClass('opened') ? 0 : $(this).parent().find('.copyrightContent').data('padding');
			var opacity = $(this).hasClass('opened') ? 0 : 1;
			
			// On anime
			$(this).parent().find('.copyrightContent').stop().animate({
				width : width + 10,
				padding : padding,
				opacity  : opacity
			});
			
			// On toggle la classe opened
			$(this).toggleClass('opened');
		});
	},
	
	selectLanguage : function()
	{
		// Récupérer la taille de tous les sous-menus
		// Pour l'animation d'ouverture / fermeture
		var sizes = [];
		$('.langueSelect li.country').each(function (i, el) {

			var languages = $(this).find('.languages');

			if(languages.length){
				sizes.push(languages.find("> li").length * 36 + 22);
			} else{
				sizes.push(0);
			}
		});


		// Cibler les éléments principaux du menu
		var langMainMenuElements = $('.langueSelect li.country');

		$('.langueSelect').css('top', -$('.langLists').innerHeight());

		// Actualiser l'animation du sous-menu selon les activation de classe "opened"
		function updateSubMenu ()
		{
			// Reparcourir pour effectuer l'animation sur tous les éléments
			langMainMenuElements.each(function (i, el) {
				// Cibler le scope
				$this = $(this);

				// Parcourir et animer chaque sous-menu selon l'état "opened"
				$this.find(".languages").stop().animate({
					height: $(this).hasClass('opened') ? sizes[i] : "0px",
					marginTop : $(this).hasClass('opened') ? 5 : 0
				}, 300);
			});
		}

		// Parcourir les éléments de menu pour l'interaction
		$('.countryName').click(function (event) {
			// Cibler le scope
			var $this = $(this).parent();

			// Marquer l'élément cliqué comme 'ouvert'
			// Enlever le marquage sur les autres éléments
			langMainMenuElements.each(function (i, el) {
				$(this).toggleClass('opened', this == $this[0] && !$(this).hasClass("opened"));
			});

			// Axtualiser l'état du sous-menu
			updateSubMenu();
		});

		// Listener du  sélecteur de langue dans le footer
		$('.langueSelected').click(function(){
			
			if(!$('.langueSelect').hasClass('opened')){
				openLangMenu();
			} else{
				closeLangMenu();
			}

			// Fermer tous les sous-menus
			langMainMenuElements.removeClass('opened');

			// Actualiser l'animation
			updateSubMenu();
		});

		$('#submenuBackgroundRepeat').click(function(){
			closeLangMenu();
		});

		function openLangMenu(){

			var additionalTop = ($('.homepage').length) ? 4 : 0;
			$('.langueSelect').stop().css('display', 'block').animate({
				top : $('header').innerHeight() + additionalTop
			});

			// On fait apparaître le fond 
			$('#submenuBackgroundRepeat').css({
				display : 'block'
			}).stop().animate({
				opacity : 1
			},200);

			$('.langueSelected').addClass('opened');

			$('.langueSelect').addClass('opened');
		}

		function closeLangMenu(){
			$('.langueSelect').stop().animate({
				top : -$('.langLists').innerHeight()
			}, function(){
				$('.langueSelect').css('display', 'none')
			});

			$('.langueSelected').removeClass('opened');

			$('#submenuBackgroundRepeat').stop().animate({
				opacity : 0
			},200, function(){
				$(this).css({
					display : 'none'
				});
			});

			$('.langueSelect').removeClass('opened');	
		}
	},

	cookie : function(){
		// Au click sur le bouton pour fermer le toast cookie
		$('.cookieToast-close').click(function(){
			$('.cookieToast').animate({
				'bottom' : -$(this).innerHeight()
			}, function(){

				// Quand c'est fini on le remove
				$(this).remove();
			});
		});
	}
};
