/**
 * DEPENDANCES : JQuery - JQuery Sticky - Underscore
 */
var FixedMenu = function (menuSelector, topSpacing)
{
	var menu = $(menuSelector);
	var blackMenu = $('#headerBottom');
	var offset = null;
	var blockOffset = [];
	var elementOnTheTop = $(menu.prev()[0].className);
	var topSpace = (topSpacing == '') ? 0 : topSpacing;

	var that = {

		construct : function(){
			if( /iPhone|iPad|iPod/i.test(navigator.userAgent) ) {
				menu.addClass('iDevice');
			}


			// On lance le sticky sur le menu
			menu.sticky({topSpacing: topSpace, className:'fixed'});
			
			// PRODUCT MENU LINK : Listener sur le product menu
			menu.find('ul li').click(function(event){

				event.stopPropagation();
				event.preventDefault();

				$(window).unbind('scroll', that.onScrollManageSelected);

				var menuElementSelected = $(this);

				// ID sur lequel scroller
				var div = $('#'+$(this).attr('data-id'));

				// Récupération de l'offset de la div lié au data-id
				var offset = div.offset();
				
				//Scroll sur la position de la div moins la taille du menu fixe
				var scrollTo = offset.top  - div.css("margin-top").replace("px", "");
				if(!$('.menu').hasClass('fixed')){
					scrollTo -= menu.height();
				}

				// On anime le scroll
				$('body, html').stop().animate({
					scrollTop: scrollTo + 2
				}, 800);

				// On ajoute la classe au bon
				menu.find('.selected').removeClass('selected');
				menuElementSelected.addClass('selected');

				$(window).bind('scroll', that.onScrollManageSelected);
			
			});
		
			// Mettre à jour l'offset du menu et des blocks lorsque la hauteur du body change
			$('body').on('heightChange', that.updateBlocksPosition);
			
			// Récuperer une première fois la position des blocks
			that.updateBlocksPosition();
			
			
		},

		/**
			 * Mettre à jour la position des blocks et du menu
			 */
		updateBlocksPosition  : function(){
			//offset = menu.offset();
			
			// Vider la liste
			blockOffset = [];
			
			// Récupération des offsets des productBlock (liés au menu)
			$('.blockMenu').each(function(){
				var top = $(this).offset().top - parseInt($(this).css('margin-top').replace('px', ''), 10);
				var bottom = top + $(this).innerHeight() + parseInt($(this).css('margin-top').replace('px', ''), 10);  
				blockOffset[$(this).attr('id')] = {'top' : top, 'bottom':bottom};
			});
		},
		

		/**
		 * On scroll : Gérer la classe selected sur les élements du menu
		 */
		onScrollManageSelected : _.debounce(function() {
			that.updateBlocksPosition();
			var currentScrollTop = $(window).scrollTop() + menu.innerHeight();//+ blackMenu.innerHeight(); 		
			
			// Quand on est fixed on check si on passe un nouveau cap
			for(var productBlock in blockOffset){

				// Si on est entre le top et le bottom d'un block et qu'on était pas déjà dessus auparavant
				if(currentScrollTop >= blockOffset[productBlock].top
					&& currentScrollTop < blockOffset[productBlock].bottom
					&& productBlock != menu.find('.selected').data('id')){

						// Gestion du selected
						menu.find('.selected').removeClass('selected');
						menu.find("li[data-id='"+productBlock+"']").addClass('selected');
				}
			}
			
		},40),
	};

	// Appeler le constructeur
	setTimeout(function(){
		that.construct();
	}, 300);

	// Listening sur le scroll pour fixer le menu
	$(window).bind('scroll', that.onScrollManageSelected);

	// Retourner le contexte du composant
	return that;
};