/**
 * Le controller des categories
 */
$(function ()
{
	/**
	 * Cibler ce controller
	 */
	var that = this;
	
	var RadioHandler = petzl.views.RadioHandler;
	
	function init(){
		
		// On parcours 
		$('.product').each(function(){
			// Réduction du titre
			// Récupération du titre
			var title = $(this).find('.productTitle');
			
			dotify(title, 2);

			
			// Réduction du texte
			// Récupération du texte
			var text = $(this).find('.productDescription');
			
			dotify(text, 4);
		});
		

		// On parcours 
		$('.tip ').each(function(){
			// Réduction du titre
			// Récupération du titre
			var title = $(this).find('p');
			
			dotify(title, 2);

			
			// Réduction du texte
			// Récupération du texte
			var text = $(this).find('.productDescription');
			
			dotify(text, 4);
		});

		// On parcours 
		$('.newsOverview').each(function(){
			// Réduction du titre
			// Récupération du titre
			var title = $(this).find('.newsTitle');
			
			dotify(title, 2);

			
			// Réduction du texte
			// Récupération du texte
			var text = $(this).find('.newsDescription');
			
			dotify(text, 4);
		});

		$('.seeAllTips').css({
			'display' : 'none',
			'opacity' : 0
		});

		// Initialisation du système de radio pour les produits
		var radioProduct= new RadioHandler('#panoplies .productContainer .product', '#panoplies', {
			handleBreadcrumb : false,
			applyFirstButton: true,
			generalRecurrence : '4n+1',
			marginValue : '0',
			elementToResize : '#panoplies .productContainer',
			callback : handleProducts
		});

		// Initialisation du système de radio pour les tips
		var radioTip = new RadioHandler('.tipsContainer .tip', '#conseils', {
			handleBreadcrumb : false,
			applyFirstButton: true,
			generalRecurrence : '4n+1',
			marginValue : '',
			elementToResize : '.tipsContainer',
			callback : handleTipsLine
		});
		setTimeout(function(){
			handleProducts();
			handleTipsLine();
		}, 700);


		// Click sur "Voir tous les conseils
		$('.seeAllTips').click(function(){
			event.preventDefault();
			// Valeur de la radio sélectionné
			$('.tipsContainer, .radioElementHeight').stop().animate({
				height : getTipsHeight($('#conseils .radio.selected').data('id'), 0)
			});

			$('.seeAllTips').animate({
				opacity : 1
			}, 400, function(){
				$(this).css('display', 'none')
			});
		});

        // Initialisation du système de menu
        var productMenu = $('#activityMenu').length > 0 ? new FixedMenu('#activityMenu', 60) : undefined;

        // Initialisation du système des news
		$('.newsContainer .newsOverview:nth-child(4n+1)').css('margin-left', '0px');

	}

	function handleProducts(){
		// Valeur de la radio sélectionné
		var radioSelected = $('#panoplies .radio.selected').data('id');

		// Si on a plus de 12 tips pour cette catégorie
		if($('#panoplies .productContainer .product.'+radioSelected).length > 12){

			$('#panoplies.productContainer, #panoplies .radioElementHeight').stop().animate({
				height : getTipsHeight(radioSelected, 3, '.productContainer .product')
			});

		} else{
			var heightToSet = getTipsHeight($('#panoplies .radio.selected').data('id'), 0, '#panoplies .productContainer .product'); 
			$('#panoplies .productContainer, #panoplies .radioElementHeight').stop().animate({
				height : heightToSet
			});
 		}
	}

	function handleTipsLine(){
		// Valeur de la radio sélectionné
		var radioSelected = $('#conseils .radio.selected').data('id');

		// Si on a plus de 12 tips pour cette catégorie
		if($('.tipsContainer .tip.'+radioSelected).length > 12){

			$('.tipsContainer, #conseils .radioElementHeight').stop().animate({
				height : getTipsHeight(radioSelected, 3, '.tipsContainer .tip')
			});

			$('.seeAllTips').css('display', 'inline-block').animate({
				opacity : 1
			});

		} else{
			var heightToSet = getTipsHeight($('#conseils .radio.selected').data('id'), 0, '.tipsContainer .tip'); 
			$('.tipsContainer, #conseils .radioElementHeight').stop().animate({
				height : heightToSet
			});

			$('.seeAllTips').animate({
				opacity : 1
			}, 400, function(){
				$(this).css('display', 'none')
			});
		}
	}


	/**
	 * Retourne la taille du nombre de ligne spécifié, Si 0 retourne la taille de toutes les lignes
	 */
	function getTipsHeight(type, limit, selector){


		var height = $(selector+'.'+type).height();
		var margin = $(selector+'.'+type).css('margin-top');

		var nbLine = Math.ceil($(selector+'.'+type).length / 4);
		return (limit != 0) ? (limit* parseInt(height, 10) + limit* parseInt(margin, 10)) : (nbLine* parseInt(height, 10) + nbLine* parseInt(margin, 10));
	}


	function dotify(element, lines){
    	// Réduction du texte
		// Line height du text
		var lineHeight = parseInt(element.css('line-height'), 10);
		if(isNaN(lineHeight)){
			console.log('Line-height non fixé');
		}
		// Hauteur de la div
		var divHeight = element.height();
		// Nombre de lignes résultant
		var nbLines = divHeight / lineHeight;
			
		// Heiht à fixer
		var fixedHeight = lines * lineHeight;
	
		//if
		// On dotdotdot
		element.css('height', fixedHeight);
		element.dotdotdot({
			ellipsis : '...',
			wrap : 'word', 
			height: fixedHeight+'px',
		});
    	
    }
	
	
	/**
	 * Initialisation
	 */
	init();
	
	
	
});
