/**
 * Le controller des categories
 */
petzl.controllers.News = function ()
{
	/**
	 * Cibler ce controller
	 */
	var that = this;
	
	var RadioHandler = petzl.views.RadioHandler;

	
	function index(){
		
		
		if($('.newsOverviewContainer').length){
		
			var radio = new RadioHandler('.newsContainer .news', '.newsOverviewContainer', {
				generalRecurrence : '2n',
				marginValue : '3%',
				handleBreadcrumb : true,
				elementToResize : '.newsContainer'
			});
			
			var loadingOffset = $('.loading').offset();
			
			$(window).scroll(function(){
				if(loadingOffset.top < $(window).scrollTop()+ $(window).height())
				{
					alert('Chargement de contenu supplémentaire');
				}	
			});
		}
		
		
	}
	
	function detail(){
		var heightToHide = 0;
		
		if($('.newsDetailContainer').length){
			/**
			 * On gère l'espace commentaire
			 */
			
			// On parcours 
			$('.linkedElements').each(function(){
				// Réduction du titre
				// Récupération du titre
				var title = $(this).find('.titleElement');
				
				dotify(title, 2);

				
				// Réduction du texte
				// Récupération du texte
				var text = $(this).find('.contentElement');
				
				dotify(text, 4);
			});
			
			// On parcours 
			$('.newsOverview').each(function(){
				// Réduction du titre
				// Récupération du titre
				var title = $(this).find('.newsTitle');
				
				dotify(title, 2);

				
				// Réduction du texte
				// Récupération du texte
				var text = $(this).find('.newsDescription');
				
				dotify(text, 4);
			});
			
			
			// Time out pour éviter que le code soit éxécuté trop tôt
			// et que les heights soit mauvaises
			window.setTimeout(function(){
				
				// On sauvegarde sa taille
				var heightComment = $('.commentsContainer').find('.commentsContentContainer').height();
				$('.commentsContainer').attr('data-height', heightComment);
				console.log($('.commentsContainer').find('.commentsContentContainer').height());
				console.log('---');
				
				// On parcours tous les commentaires
				$('.commentsContainer .commentsContent .commentsContentContainer>.comment').each(function(index){
					// Si on est dans les trois premirs
					if(index<=2){
						
						// On cumule sa height et sont margin top
						heightToHide += $(this).height() + parseInt($(this).css('margin-top').replace('px', ''), 10)+10;
						console.log( $(this).height() + parseInt($(this).css('margin-top').replace('px', ''), 10));
					}
				});
				
				// On cache du contenu et on garde queles trois premiers commentaires
				$('.commentsContainer .commentsContentContainer').css('height', heightToHide);
				
				// Handler sur le lire la suite
				$('.readNext').click(function(event){
					event.preventDefault();
					
					var height = $('.commentsContainer').data('height');
					
					$('.commentsContainer .commentsContentContainer').animate({
						height : height
					});
					
					$(this).animate({
						opacity : 0
					}, 300, function(){
						$(this).css('display','none');
					});
				});
			}, 200);
		}
	}

	

	function dotify(element, lines){
    	// Réduction du texte
		// Line height du text
		var lineHeight = parseInt(element.css('line-height'), 10);
		if(isNaN(lineHeight)){
			console.log('Line-height non fixé');
		}
		// Hauteur de la div
		var divHeight = element.height();
		// Nombre de lignes résultant
		var nbLines = divHeight / lineHeight;
			
		// Heiht à fixer
		var fixedHeight = lines * lineHeight;
		// On dotdotdot
		element.css('height', fixedHeight);
		element.dotdotdot({
			ellipsis : '...',
			wrap : 'word', 
			height: fixedHeight+'px',
		});
    	
    }
	
	/**
	 * Initialisation
	 */
	index();
	
	detail();
	
	
};