/**
 * Le controller de la Homepage
 */
petzl.controllers.Home = function ()
{
	/**
	 * Cibler ce controller
	 */
	var that = this;
	
	var firstLoad = true;
	
	/**
	 * Initialisation
	 */
	function init(){
		
	};
	
	// Fonction contenant les listeners de la Home
	function listener(){
		
		// Si on est sur la home V2
		if($('.homepage_v2').length){
			// Survol d'un des menus Sport ou Professionnel de la home
			$('header .menuTop ul li').hover(function(){
				_openHomeMenuFromTop($(this).find('.menuDescription'), $(this).find('.menuBackground'));
				
			}, function(){
				_closeHomeMenuFromTop($(this).find('.menuDescription'), $(this).find('.menuBackground'));
			});
			
		}else{
			// Survol d'un des menus Sport ou Professionnel de la home
			$('header .menuTop ul li').hover(function(){
				_openHomeMenuFromBottom($(this).find('.menuDescription'), $(this).find('.menuBackground'));
				
			}, function(){
				_closeHomeMenuFromBottom($(this).find('.menuDescription'), $(this).find('.menuBackground'));
			});
			
		}
		
		
	}
	
	
	/**
	 * HOMEPAGE
	 */
	// Montre le texte du menu de la Home
	function _openHomeMenuFromBottom(description, background){
		var backgroundHeight = $(background).height();
		var descriptionHeight = $(description).innerHeight();
		
		if(firstLoad)
		{
			$('.menuDescription').css('top', backgroundHeight+'px');
			firstLoad = false;
		}
		
		$(description).stop().animate({
			top : backgroundHeight-descriptionHeight+'px'
		},500);
	}
	
	// Cache le texte du menu de la Home
	function _closeHomeMenuFromBottom(description, background){
		var backgroundHeight = $(background).height();
		
		$(description).stop().animate({
			top : backgroundHeight+'px'
		},500);
	}
	
	/**
	 * HOMEPAGE V2
	 */
	
	// Montre le texte du menu de la Home
	function _openHomeMenuFromTop(description, background){
		var backgroundHeight = $(background).height();
		var descriptionHeight = $(description).innerHeight();
		
		if(firstLoad)
		{
			$('.menuDescription').css('bottom', backgroundHeight+'px');
			firstLoad = false;
		}
		
		$(description).stop().animate({
			bottom : backgroundHeight-descriptionHeight+'px'
		},500);
	}
	
	// Cache le texte du menu de la Home
	function _closeHomeMenuFromTop(description, background){
		var backgroundHeight = $(background).height();
		
		$(description).stop().animate({
			bottom : backgroundHeight+'px'
		},500);
	}
	
	/**
	 * Lancer l'initialisation
	 */
	init();
	
	listener();
};