/**
 * Le controller des categories
 dropbox 
 */
petzl.controllers.Category = function ()
{
	var ensavoirplusLang = '';
	var popinCategory = $('.popinCategory');
	if (popinCategory.length)
		ensavoirplusLang = popinCategory.html().trim().split(' ').join('-').replace('?', '');//MY 02.04.2015 ;the wablable url on diffrent languages

	var RadioHandler = petzl.views.RadioHandler;
	var popin = null;

	var isInitPhase = true;

	init();

	function init() {
		$.address.change(function (event) {
			if (event.value && event.value.endsWith('/' + ensavoirplusLang)) {
				if (!isInitPhase) openPopinMarket();
			} else if (popin) {
				$.colorbox.close();
			}
		});

		new RadioHandler(
			'.productContainer .product',
			'.productContainer',
			{
				handleBreadcrumb : true,
				callback : linkedTextHandler,
				elementToResize : '.categoryContainer'
			}
		);
		
		// On initialise le lancement de la colorbox
		popinCategory.on('click', function (event) {
			event.preventDefault();
			if (!isInitPhase) $.address.value($.address.value() + '/' +ensavoirplusLang);
		});


		var nbLinesForTitle = 2;
		var nbLinesForText = 4;
		// On parcours 
		$('.product').each(function () {
			// Si y'a besoin de dotify on le fait
			if (getNbLines($(this).find('.productTitle')) > nbLinesForTitle) {
				dotify($(this).find('.productTitle'), nbLinesForTitle);
			} 

			if(getNbLines($(this).find('.productDescription')) > nbLinesForText){
				dotify($(this).find('.productDescription'), nbLinesForText);
			}
		});
		
		
		var pathNames = $.address.pathNames();
		var subFamilyUrlName = decodeURIComponent(pathNames[0]);
		switch (pathNames.length) {
			case 1: // openPopinMarket OR look for subcategory at radio buttons panel
				sequenceCalls(
					function () { $('#contentCategory .radioContainer [data-name="' + subFamilyUrlName + '"]').click(); },
					function () { isInitPhase = false; }
				);
				break;
			case 2: // look for subcategory at radio buttons panel; then openPopinMarket
				sequenceCalls(
					function () { $('#contentCategory .radioContainer [data-name="' + subFamilyUrlName + '"]').click(); },
					openPopinMarket,
					function () { isInitPhase = false; }
				);
				break;
			default :
			case 0:
				$.colorbox.close();
				isInitPhase = false;
				break;
		}

    hideDuplicate();

	}


	/**
	 * Ouvrir la popin market
	 */
	function openPopinMarket(){
		popin = $('.colorbox_popup:visible').colorbox({
			//href:"https://www.facebook.com", 
			inline:true,
			open: function () { return isInitPhase; },
			onComplete : function(){
				// HK: 23/04/2017 -- popin issue
				$('#cboxContent').css('width', $('#cboxContent').find('.popin').outerWidth());

				$('.cross').click(function(){
					$.colorbox.close();
				});
				
				// Si on est sur iOS 
				if ( navigator.userAgent.match(/(iPad|iPod)/g)){
					// On ajoute la classe au container
					$('#colorbox').addClass('ios');
				} 

				var userAgent = navigator.userAgent.toLowerCase();
				// Si on est sur un android mobile ou sur un iphone et qu'on a une taille inférieure à 1024
				if( (((userAgent.search("android") > -1) && (userAgent.search("mobile") > -1)) || navigator.userAgent.match(/(iPhone)/g)) && $(window).width() < 1024){
					$('#colorbox').addClass('mobile');
				}
			},
			onClosed: function(){
				$.address.value($.address.pathNames()[0]);
			}
		});
	}
	window.openPopinMarket = openPopinMarket;


	/**
	 * Gère le changement de text selon le clique sur un bouton radio
	 */
	function linkedTextHandler(triVal){
		// GA events on filtering - H.K
		var radio = document.querySelector('.radioContainer .radio[data-id="' +  triVal + '"]');
		_gaq.push(['_trackEvent', 'filters', 'select_filter_family', radio.getAttribute('data-orgignal-name').trim()]);
		if (!isInitPhase) {
			var subFamilyUrlName = radio.getAttribute('data-name').trim();
			$.address.value((!subFamilyUrlName || 'all' === subFamilyUrlName) ? '' : ('/' + subFamilyUrlName));
		}

		var current  = $('.categoryDescriptionContainer .currentCategory');

		var animateDelay = isInitPhase ? 0 : 500;

		if($('.categoryDescriptionContainer .'+triVal)[0] != current[0]){
			// Si la catégorie n'est pas 'all'
			if(current.length > 0){
				// On enlève l'ancienne description
				current.removeClass('currentCategory').animate({
					opacity : 0
				}, animateDelay, function(){
					$(this).css('display','none');
					
					// Si on passe d'une autre catégorie à 'all'
					if(triVal == 'all'){
						$('.categoryDescriptionContainer').addClass('all');
						$('.productContainer').addClass('all');
						$('.product').removeClass('productEnlarged');
            hideDuplicate();
					} 
					
					// On affiche la bonne description
					$('.categoryDescriptionContainer .'+triVal).addClass('currentCategory').css('display','block').animate({
						opacity : 1
					} , animateDelay);
				});
			}
			// Si on passe de 'all' à une autre catégorie
			else{
				// Description choisi
				var description = $('.categoryDescriptionContainer .'+triVal);
				
				// On fait apparaitre la colonne de description
				$(description.parent()).removeClass('all');
				$('.productContainer').removeClass('all');
				$('.product').addClass('productEnlarged');
				
				// On anime l'aparition de la description
				description.addClass('currentCategory').css('display','block').animate({
					opacity : 1
				} , animateDelay * 2);
				
			}
		}
	}

	/**
	 *  Retourne le nombre de lignes de l'élément
	 */
	function getNbLines(element) {
		return element.height() / parseInt(element.css('line-height'), 10);
	}

	function dotify(element, lines){
    	// Réduction du texte
		// Line height du text
		var lineHeight = parseInt(element.css('line-height'), 10);
		if(isNaN(lineHeight)){
			console.log('Line-height non fixé');
		}
		// Hauteur de la div
		var divHeight = element.height();
		// Nombre de lignes résultant
		var nbLines = divHeight / lineHeight;
			
		// Heiht à fixer
		var fixedHeight = lines * lineHeight;
		// On dotdotdot
		element.css('height', fixedHeight);
		element.dotdotdot({
			ellipsis : '...',
			wrap : 'word', 
			height: fixedHeight+'px',
		});
    	
    }

	if (!String.prototype.endsWith) {
		String.prototype.endsWith = function (search, this_len) {
			if (this_len === undefined || this_len > this.length) {
				this_len = this.length;
			}
			return this.substring(this_len - search.length, this_len) === search;
		};
	}

	function sequenceCalls() {
		var tasks = Array.prototype.slice.call(arguments);
		(function next(i) {
			setTimeout(function () {
				tasks[i]();
				if (++i < tasks.length) next(i);
			});
		})(0);
	}
  
  function hideDuplicate() {
		var found = {};

		$("div[data-prod-id]").each(function(){
			var $this = $(this);
			var prodId = $this.attr("data-prod-id");

			if(found[prodId]){
				console.log('prodId found = ' + prodId);
				$this.removeClass('showed').animate({opacity : 0},500, function(){
			
					$(this).css('display', 'none');
				});
			}else{
				found[prodId] = true;
			}
		});  
  }
};