$(document).ready(function() {
    const timing = $('.mea-timer').html();

    // VARS
    let popState = true;
    const container = $('.mea-popin')
    const popup = $('.mea-popin__content');
    const dimmer = $('.mea-popin__dimmer');
    const reduceBtn = $('.mea-popin__reduce');
    const closeBtn = $('.mea-popin__close');
    const closedContent = $('.mea-popin__closed-content');
    const openedContent = $('.mea-popin__opened-content');
    const arrowFull = $('.mea-popin__arrow-full');
    const arrowSmall = $('.mea-popin__arrow-small');

    // LISTENERS
    reduceBtn.click(toggleSize);
    closedContent.click(toggleSize);
    closeBtn.click(close);
    dimmer.click(toggleSize);

    // FUNCTIONS
    function toggleSize() {
        // Add either the opened content or closed content
        if (popState) {
            // Enable closed content
            closedContent.css('display', 'block');
        } else {
            // Enable closed content
            openedContent.css('display', 'block');
        }

        // Animate size of popup
        popup.stop().animate({
            height: (popState) ? closedContent.innerHeight() : openedContent.innerHeight(),
            width: (popState) ? closedContent.innerWidth() : openedContent.innerWidth()
        }, 400, 'swing');

        // Show/hide the closed content
        closedContent.stop().animate({
            opacity: (popState) ? 1 : 0
        }, 400);

        // Show/hide the opened content
        openedContent.stop().animate({
            opacity: (popState) ? 0 : 1
        }, 400);

        // Change arrow
        arrowFull.stop().animate({
            opacity: (popState) ? 0 : 1
        });

        arrowSmall.stop().animate({
            opacity: (popState) ? 1 : 0
        });

        reduceBtn.stop().animate({
            width: (popState) ? '48px' : '64px',
            height: (popState) ? '54px' : '64px',
            right: (popState) ? '16px' : '0px'
        })

        // Show/hide dimmer
        dimmer.css('display', 'block').stop().animate({
            opacity: (popState) ? 0 : 1
        }, 400, () => {
            dimmer.css('display', (popState) ? 'block' : 'none')
        });

        // Remove either the opened content or closed content
        if (popState) {
            // Enable closed content
            openedContent.css('display', 'none');
        } else {
            // Enable closed content
            closedContent.css('display', 'none');
        }
        (popState) ? document.cookie = 'slidein_session=folded;path=/;' : document.cookie = 'slidein_session=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;'
        popState = !popState;
    }

    function close() {
        popup.animate({
            bottom: - popup.innerHeight()
        }, 500);

        dimmer.animate({
            opacity: 0
        }, 500, () => {
            container.remove();
        });


        var isStatusClosed1 = isCookieExist('slidein_status=closed_1');
        var isStatusClosed2 = isCookieExist('slidein_status=closed_2');
        var isStatusClosed3 = isCookieExist('slidein_status=closed_3');

        var date = new Date();
		date.setTime(date.getTime()+(90*24*60*60*1000));
        if(!isStatusClosed1 && !isStatusClosed2 && !isStatusClosed3) {
            document.cookie = 'slidein_session=closed;path=/;';
            document.cookie = 'slidein_status=closed_1;path=/; expires=' +date.toGMTString() +';';
        }
        else if(isStatusClosed1) {
            document.cookie = 'slidein_session=closed;path=/;';
            document.cookie = 'slidein_status=closed_2;path=/; expires=' +date.toGMTString() +';';
        }
        else if(isStatusClosed2) {
            document.cookie = 'slidein_status=closed_3;path=/; expires=' +date.toGMTString() +';';
        }

    }

    function open() {
        popup.animate({
            bottom: '16px'
        }, 500);

        dimmer.animate({
            opacity: 1
        }, 500);
    }

    function isCookieExist(cookieNameValue) {
        return document.cookie
        .split('; ')
        .filter(a => a === cookieNameValue).length > 0;
    }

    function init() {
        var isSessionFolded = isCookieExist('slidein_session=folded');
        var isSessionClosed = isCookieExist('slidein_session=closed');
        var isStatusFolded = isCookieExist('slidein_status=folded');
        var isStatusClosed = isCookieExist('slidein_status=closed_3');
       
        if(isSessionFolded || isStatusFolded) {
            setTimeout(() => {
                if(!$('.slideid').html()) return;
                container.css('display', 'block');
                toggleSize();
                dimmer.css('display', 'none');
                popup.css('bottom', -popup.innerHeight());
                open();
            }, timing * 1000);
        }
        else if(isSessionClosed || isStatusClosed) {
            container.css('display', 'none');
        }
        else {
            setTimeout(() => {
                if(!$('.slideid').html()) return;
                    
                container.css('display', 'block');
                dimmer.css('display', 'block');
                popup.css('bottom', -popup.innerHeight());

                open();
            }, timing * 1000);    
        }
    }

    init();
});
