$(function() 
{
	getURLparameters();
});


function getURLparameters()
{
	var b2cServerDomainPrefix = 'mobile';
	console.log('getURLparameters');
	var urlPath = window.location.pathname;
	console.log('urlPath: '+ urlPath);
	var pathWithoutB2C = (urlPath.split(b2cServerDomainPrefix).length > 1 && b2cServerDomainPrefix) ? urlPath.split(b2cServerDomainPrefix)[1] : urlPath;
	console.log('pathWithoutB2C: '+ pathWithoutB2C);
	var countryCode = pathWithoutB2C.split('/')[1];
	var languageCode = pathWithoutB2C.split('/')[2];
	verifyCountryAndLanguage(countryCode, languageCode);
}


function verifyCountryAndLanguage(countryCode, languageCode)
{	
	var countryCodeSet = $("#countryCodeSet").attr("data-value");
	var countryLanguageList = $("#countryLanguageList").attr("data-value");
	var languageCountry = languageCode +'-'+ countryCode;
	// Country & language codes are valid
	if((countryCodeSet 
		&& countryCodeSet != 'undefined' 
		&& countryCodeSet.indexOf(countryCode) > -1 
		&& countryLanguageList.toLowerCase().indexOf(languageCountry.toLowerCase()) > -1)
		|| countryCode && countryCode.toLowerCase() == 'int')
		
	{
		console.log('valid country language code to update cookies')
		updateCookies('country', countryCode);
		updateCookies('language', languageCode);
		
	}
}

function updateCookies(cookieName , cookieValue)
{ 
	var date = new Date();
	
	//set expire 10 years
	date.setTime(date.getTime()+(365*10*24*60*60*1000));   
	if(cookieValue)
	{
		document.cookie = 'apex__' + cookieName + '=' + cookieValue + ';' + 'path=/; expires=' + date.toGMTString() + ';';
	}			
}