var offset = 0,
    lastFilter = $('#activitiesFilter').find('.selected').attr('data-filter-name'),
    completed = true;

$('#activitiesFilter').on('click', '.radio', function () {
    $('#activitiesFilter').find('.selected').removeClass('selected');
    this.classList.add('selected');
    lastFilter = this.dataset.filterName;

    offset = 0;

    $('.loadingContainer').show();
    $('#recallsContainer').empty();

    getRecalls();
});

$(window).scroll(function () {
    if (!completed) return;

    if ($(window).scrollTop() + $(window).height() >= $(document).height() && completed) {
        completed = false;
        getRecalls();
    }
});

function getRecalls() {
    Web_RecallsOverview.getRecalls(UTILS.universId, UTILS.language, UTILS.country, 'Archives' === lastFilter, offset||0, renderRecalls);
}

// Web_RecallsOverview.getAllRecalls(UTILS.universId, UTILS.language, UTILS.country, renderRecalls);
getRecalls();

function renderRecalls(/**Object[]*/recalls, /**Object*/ev) {
    $('.loadingContainer, #noResult-Ongoing, #noResult-Archives').hide();

    if (recalls.length) {
        UTILS.dustRender('tmpl_animations', recalls, $('#recallsContainer'));
        offset += recalls.length;
    } else {
        $(`#noResult-${ lastFilter }`).show();
    }
}

moment.locale(UTILS.country);
dust.filters.urlDateFormat = function (ddd) { return moment(ddd).format('YYYY-MM-DD'); };
dust.filters.displayDate = function (ddd) { return moment(ddd).format('LL') };

UTILS.compileDustTemplates();
