﻿/**
 * Le controller de la Homepage
 */
petzl.controllers.Market = function ()
{
	/**
	 * Cibler ce controller
	 */
	var that = this;
	
	 var ClassicSlideshow = petzl.views.ClassicSlideshow;
	 var ThumbsSelector = petzl.views.ThumbsSelector;
	
	/**
	 * Initialisation
	 */
	function init(){
		
		// On récupère la bonne couleur selon la page
		var color = ($('#contentSport').length != 0) ? "o" : "y";
		
		// On initialise le slideshow et les thumbs
		var slideshow = new ClassicSlideshow('#slideshow', {
			autoStart: true,
			index: 1,
			duration: 4000,
			opacityAnimation : true,
			transitionDuration: 500
		});

		var selector = new ThumbsSelector('#slideshow #thumbsContainer .thumbsContent', {
			intro: false,
			index: 1,
			alpha : false, 
			color : color
		});
		
		// Ecouter les changements de slide sur le slideshow
		slideshow.onChange = function (pIndex){
			// Appliquer sur le selecteur et sur l'autre slideshow
			selector.select(pIndex);
		};

		// Ecouter les changements de slide sur le selecteur
		selector.onChange = function (pIndex){
			// Appliquer sur les slideshow
			slideshow.select(pIndex);

			// Redémarrer le timer
			slideshow.restart();
			
			
			$('#thumbsPause').removeClass('paused');
			
			animatePauseIcon();
		};
		
		// Click sur pause
		$('#thumbsPause').click(function(){
			
			// On ajoute la classe paused au bouton
			$(this).toggleClass('paused');
			
			if($(this).hasClass('paused')){
				// On arrête le slideshow
				slideshow.stop();
				selector.pauseThumb();
				
			} else{
				// On redémarre le slideshow
				slideshow.restart();
				slideshow.start();
				
				// On redémarre le thumb
				selector.restartThumb();
			}
			
			animatePauseIcon();
		});
    };

    function animatePauseIcon(){
    	// On anime le changement d'icone
		if($('#thumbsPause').hasClass('paused')){
			$('#thumbsPause').find('.iconPause').animate({
				opacity : 0
			}, 100, function(){
				$('#thumbsPause .iconPlay').css('display', 'block');
				$('#thumbsPause').find('.iconPause').css('display', 'none');
				
			});
			$('#thumbsPause .iconPlay').animate({
				opacity : 1
			}, 300);	
		} else{
			$('#thumbsPause').find('.iconPlay').animate({
				opacity : 0
			}, 100, function(){
				$('#thumbsPause .iconPause').css('display', 'block');
				$('#thumbsPause').find('.iconPlay').css('display', 'none');
				
			});
			$('#thumbsPause .iconPause').animate({
				opacity : 1
			}, 300);
		}
    }
	
	/**
	 * Lancer l'initialisation
	 */
	init();
	
};