// HK 24/05/2016 - Set timeout for maxmind service

if (navigator.appName === 'Microsoft Internet Explorer' && XDomainRequest && navigator.appVersion.indexOf("MSIE 1") === -1) {
	window.XRequest = XDomainRequest;
}
else {
    window.XRequest = XMLHttpRequest;
}

(function(send) {
	XRequest.prototype.send = function(data) {
		// Set a timeout only if request to maxmind.com 
		if (this._url.indexOf('maxmind.com') >= 0)
			this.timeout = 2000;
		send.call(this, data); 
	};
})(XRequest.prototype.send);   

(function(open) {
	XRequest.prototype.open = function(method, url, data) {
		this._url = url;
		open.call(this, method, url, data);
	};
})(XRequest.prototype.open);   

if (typeof String.prototype.endsWith !== 'function') {
    String.prototype.endsWith = function(suffix) {
        return this.indexOf(suffix, this.length - suffix.length) !== -1;
    };
}

if (typeof console === "undefined" || typeof console.log === "undefined") {
     console = {};
     console.log = function() {};
}

function HomeRedirect() {
	debugger;
	var set = {};
	var siteDomain = $('#siteDomain').text();
	var path = '';

	// HK W-000085 Maxmind/INT - Improvement of migration from old geoip service
	var b2cServerDomainPrefix = '/' + $('#b2cServerDomainPrefix').attr('href');
	
	var countryState = {
		country:	$.cookie("apex__country"),
		lang:		$.cookie("apex__language"),
		isUnknownLocaleUrl:  !!b2cServerDomainPrefix && window.location.pathname.endsWith(b2cServerDomainPrefix)
							|| window.location.pathname.endsWith(b2cServerDomainPrefix + '/')
	};

	if (!countryState.country || !countryState.lang
		|| countryState.country == 'INT' && countryState.isUnknownLocaleUrl
		)
	{	
		$('#contryLang .CountryCode').each(
		   function(index,elem){
			  var cc = $(elem).text();
			  set[cc]= true;
		   });
		   
		
		
		var onSuccess = function(location)
		{	
			console.log('onSuccess set: ' , set);
			console.log('onSuccess IF condition: ' + location.country.iso_code && location.country.iso_code in set);
			
			if (location.country.iso_code && location.country.iso_code in set ){
				updateCookie('country', location.country.iso_code);
				updateCookie ('language', $('#'+location.country.iso_code+' .LangugageCode').text());				
			}
			else
			{
				updateCookie ('country','INT');
				updateCookie ('language', 'en');
			}
			redirectWithCookies(siteDomain);
		};

		var onError = function(error)
		{
			updateCookie ('country','INT');
			updateCookie ('language', 'en');
			redirectWithCookies(siteDomain);
		};
		geoip2.country(onSuccess, onError);
	}
	
	else{
		
		path = '/' + $.cookie("apex__country") + '/' + $.cookie("apex__language");
		
		window.location.href = siteDomain + path;
	}
	//updateCookie ('language', $('#languageNameCode').text());
	
	
}

// HK W-000085 Maxmind/INT - Improvement of migration from old geoip service
function redirectWithCookies (domain){
	var p = '/' + $.cookie("apex__country") +'/' + $.cookie("apex__language");
	window.location.href = domain + p;
}

function updateCookie(cookieName , cookieValue){ 
		var date = new Date();
		date.setTime(date.getTime()+(365*10*24*60*60*1000));   //set expire 10 years
		if(cookieValue){
				document.cookie = 'apex__'+cookieName+'='+cookieValue + ';' + 'path=/; expires=' +date.toGMTString(); +';'
		}			
}

HomeRedirect();

