/**
 * Le controller de la Homepage
 * AEF: 11/05/2015 updated  
 */
 petzl.controllers.Contact = function ()
 {
	 
	 /**
	  * Cibler ce controller
	  */
	 var that = this;
	 
	 /**
	  * Initialisation
	  */
	 function init(){
 
		 if(navigator.userAgent.match(/iPad/i) != null){
			 $('.contactContainer h1').css('font-size', '45px');
		 }
		 
		 $('.showError').click(function(){
			 $('.errorMessage').animate({
				 'opacity' : 1
			 }, 300);
		 });
 
		 // Les selects.
		 $.Select();
 
		 /// Click sur le body pour fermer
		 $('body').click(function(){
			 // Pour chaque select
			 $('.select').each(function(){
				 // S'il est ouvert
				 if($(this).hasClass('opened')){
					 // On le toggle (et donc le ferme)
					 toggleSelect($(this));
				 }
			 });
		 });
		 
		 // Click sur un select
		 $('.select').click(function(event){
			 if(event.preventDefault) event.preventDefault();
			 if(event.stopPropagation) event.stopPropagation();
			 event.returnValue = false;
 
 
			 // Pour chaque select
			 $('.select').each(function(){
				 // Si il est ouvert
				 if($(this).hasClass('opened')){
					 // On le ferme
					 toggleSelect($(this));
				 }
			 });
			 // On ouvre celui là
			 toggleSelect($(this));
		 });
		 
		 $('.select input').each(function(){
			 var param = $(this).val();
			 if (param != ''){
				 param = param.replace(/ /g,'_');
				 var val = $('.selectChoices span.'+param).text();
				 $(this).parent().find('.currentChoice').html(val);
				 
			 }
		 });
		 
		 // Click sur un des choix du du select 
		 $('.select .selectChoices span').click(function(event){
 
			 if(event.preventDefault) event.preventDefault();
			 if(event.stopPropagation) event.stopPropagation();
			 event.returnValue = false;
			 
			 var select = $(this).parents('.select');
			 var selectChoices = $(this).parents('.selectChoices');
			 
			 var dataId = $(this).attr('data-id');
			 var value = (dataId) ? $(this).html() :dataId ;
			 
			 $(this).parent().parent().find('input').val(dataId);
			 $(this).parent().parent().find('.currentChoice').html(value);
 
			 // On referme le select
			 selectChoices.css('display', 'none');
			 select.removeClass('opened');
		 });
 
 
		 $(".InputSelect").each(function(index, element){
 
			 $('select', element).change(function(event){
				 var $selectedOption = $('option:selected', event.target);
				 // Stickers
				 if ($(event.target).is('.request-selector')){
					 if ($selectedOption.val() == 'SAV'){
						 $('.contact_stickers_block').show();
					 //     $('.contact_subject_block').hide();
					 //     $('.Country_Selector').appendTo('.country_selector_placeholder_stickers');
						 if (['UNITED STATES','CANADA'].includes($('.Country_Selector .InputSelect select option:selected').text())) {
							 $('.State_Selector').show();
							 //$('.state-selector_background .InputSelect_value ').text('{!WebLabels['choose state']}');
							 $('.serverChosenState').val('');
						 }
					 } else {
						 // $('.contact_subject_block').show();
						 $('.contact_stickers_block').hide();
						 $('.State_Selector').hide();
						 // $('.Country_Selector').appendTo('.country_selector_placeholder');
					 }
				 }				
				 $('.InputSelect_value', element).text($selectedOption.text());
				 $('input[type=text]', element).val($selectedOption.val());
			 });
  
			 $('select', element).find('option').each(function(oIndex, oElement){
				 if($(oElement).attr('selected')){
					 $('.InputSelect_value', element).text($(oElement).text());
					 $('input[type=text]', element).val($(oElement).val());
				 }
			 });
		 });
 
		 $('.Country_Selector .InputSelect select').change(function(event){				
			 var selectedCountry = $('option:selected', event.target).text();
			 var stateLst = JSON.parse($('.stateMap').val());
			 var chooseStateLabel = $('.chooseStateLabel').val();
			 $('.state-selector').empty();
			 $('.state-selector').append('<option value="" selected="true" disabled="true">' + chooseStateLabel + '</option>');
			 $.each(stateLst[selectedCountry], function (i, item) {
				 $('.state-selector').append('<option value="' + item + '">' + item + '</option>');
			 });
			 $('.serverChosenState').val('');
			 $('.state-selector_background .InputSelect_value').text(chooseStateLabel);
 
			 if(['UNITED STATES','CANADA'].includes(selectedCountry) && $('.request-selector option:selected').val() == 'SAV') {
				 $('.State_Selector').show();
			 }
			 else {
				 $('.State_Selector').hide();
			 };
			 isAvailableB2C(selectedCountry);
		 });
	 };
	 
	 // Ouverture/Fermeture du select
	 function toggleSelect(elem) {
		 // On récupère la visibilité du biniou
		 var visibility = (elem.find('.selectChoices').css('display') == 'block') ? 'none' : 'block';
 
		 // On toggle sa visbilité
		 elem.find('.selectChoices').css('display', visibility);
		 elem.toggleClass('opened');
	 }
	 
	 /**
	  * Lancer l'initialisation
	  */
	 init();
 };
 
 $.fn.scrollToElement = $.fn.scrollToElement || function(){
	  $('html, body').animate({
		 scrollTop: this.offset().top - 60
	 }, 1000);
 };
 
 
 