petzl.views.RadioHandler = function (pSelector, pContainer, pOptions)
{
	
	/**
	 * Parametres : 
	 * PSelector : string
	 * 		- Les éléments qu'il faut trier
	 * pContainer : string
	 * 		- Le container general qui contient le radioContainer et les éléments
	 */
	
	/**
	 * Options :
	 * applyFirstButton : boolean
	 * 	- Sélectionne le premier bouton ou non
	 * generalRecurrence : string (ex : '3n+1')
	 * marginValue : string (ex : '3%')
	 * 	- Gérer le margin de certaines récurrences 
	 * callback : function
	 */
	
	var that = this;

	var levels = [];
	
	var items = pSelector;
	
	var generalContainer = pContainer;
	
	var triVal;
	
	that.animating = false;
	
	// Les options
	var options = $.extend({
		applyFirstButton : false,
		handleBreadcrumb : false,
		generalRecurrence : '',
		handleBreadcrumb : false,
		callback : null,
		elementToResize : ''
	}, pOptions);
	
	function init(){
		if(options.handleBreadcrumb){
			// On cache les breadcrumb du niveau le plus haut
			$('.breadcrumbLink').each(function(){
				levels.push($(this).data('level')); 
			});
			var max = Math.max.apply(Math, levels);
			
			$('.breadcrumbLink.level_'+max).css({display : 'none', opacity : 0});
		}
		
		if(options.generalRecurrence != '' && options.marginValue != ''){
			$(items+':nth-child('+options.generalRecurrence+')').css({marginLeft : options.marginValue});
		}
		
		// Si on veut sélectionner le premier bouton par défaut
		if(options.applyFirstButton == true){
			that.applyFirstRadioButton();
		}
		
		/**
		 * Lancer les listener
		 */
		that.radioHandler();
	}
	
	/**
	 * Fonction gérant le système de boutons radio
	 */
	this.radioHandler = function(){
			
		// Clic sur un bouton radio
		//<!--HK 22/05/2016 W-000086 switch GA to mouseup-->
		$(generalContainer).find('.radio').on('click mouseup', function(e){

			if (that.animating) return;
			
			//<!--HK 22/05/2016 W-000086 switch GA to mouseup-->
			// Technique to perform mouse event only once
			if (e.type == 'mouseup'){
				if (e.which != 1){// Not Left button, so no click event will be performed
					$(this).click();// Perform click event
				}
				return;
			}

			if(options.elementToResize){
				$(options.elementToResize).parents('.radioElementHeight').css(' height', $(options.elementToResize).height());
			}
			
			//Le bouton choisi
			var selectedRadio = $(this);
			
			//On retire la classe selected au précédent
			selectedRadio.parent().find('.radio.selected').removeClass('selected');
			
			//Ajout de la classe selected au bouton sélectionné
			selectedRadio.addClass('selected');
			
			//On récupère la valeur sur laquelle trier 
			triVal = selectedRadio.attr('data-id');
			
			
			if(options.handleBreadcrumb){
				// Ajout du breadcrumb
				breadcrumbHandler();
			}
			
			if(options.callback){
				options.callback(triVal);
			}
			
			
			if(triVal == 'all')
			{
				$(items).css('display', 'inline-block').stop().animate({
					opacity : 1
				}, 500).addClass('showed');
				
			}
			// Tous les produits qui n'ont pas la bonne valeur
			else{
				that.radioChange(triVal);
			}
			
			if(options.generalRecurrence != '' && options.marginValue != ''){
				$(items+'.'+triVal+':nth-child('+options.generalRecurrence+')').css({marginLeft : options.marginValue});
			}
			
			that.updateParentSize(0, null);
		});
	};
	
	// Update la taille du container
	this.updateParentSize  = function(pDuration, pHandler)
	{
		if(options.elementToResize){
			$(options.elementToResize).parents('.radioElementHeight').stop().animate({
				height :  $(options.elementToResize).height()
			}, pDuration >= 0 ? pDuration : 300, pHandler);
		} else{
			pHandler();
			
			that.animating = false;
		}
	};
	
	this.radioChange = function (triVal){
		that.animating = true;
		
		// On cache les items qui ne concerne pas la valeur de tri
		$(items+':not(.'+triVal+')').removeClass('showed').animate({
			opacity : 0
		}, 500, function(){
			
			$(this).css('display', 'none');
			
			// On affiche les bon produits
			var newItem = $(items+'.'+triVal);
			
			setTimeout( function() {
				newItem.stop().css({
					display: "inline-block"
				});
				
				console.log('yayaya');
				
				that.updateParentSize(200, function () {
					newItem.animate({
						opacity : 1
					}, 500, function () {
						console.log('GOES FALSE');
						that.animating = false;
					}).addClass('showed');
				});
			}, 100);
		});
		
		that.animating = false;
	};
	
	
	this.applyFirstRadioButton = function(){
		// On récupère le premier bouton radio du container
		var firstRadioButtonVal = $(generalContainer).find('.radioContainer .radio').first();
		
		// On lui attribue la valeur selected
		firstRadioButtonVal.addClass('selected');
	
		// On applique les bons changements
		that.radioChange(firstRadioButtonVal.attr('data-id'));
	};
	
	/**
	 * Gère le changement de breadcrumb selon le clique d'un bouton radio
	 */
	function breadcrumbHandler(){
		var breadcrumb = $('.breadcrumbLink.'+triVal);
		var level = breadcrumb.data("level");
		
		if($('.last')[0] != breadcrumb[0]){
			// Si on revient sur l'affichage all
			if(triVal == 'all'){
				// On vire le breadcrumb précédent si on a pas cliqué sur le même bouton
				$('.breadcrumbLink.last').removeClass('last').animate({
					opacity : 0
				}, function(){ 
					$(this).css('display', 'none');
				});
				$('.level_'+level).addClass('last');
				
			}else
			{
				var last = $('.last');
				
				// Si on a déjà un breadcrumb de niveau 3
				if(last.length && last.hasClass('level_'+level)){
					// On cache le précédent breadcrumb
					last.stop().animate({
						opacity : 0
					}, 300, function(){
						// On le vire totalement une fois animé
						$(this).removeClass('last').css('display', 'none'); 
						// On affiche le bon breadcrumb
						setTimeout( function() {
							breadcrumb.stop().css('display','inline-block').animate({
								opacity : 1
							}, 300).addClass('last');
						}, 100);
					});
				} 
				// Si on a pas de breadcrumb niveau 3
				else
				{
					// On affiche le bon breadcrumb
					breadcrumb.stop().css('display','inline-block').animate({
						opacity : 1
					}, 300).addClass('last');
				}
				// On retire la classe last du breadcrumb du niveau en dessous
				$('.level_'+(level-1)).removeClass('last');
			}
		
		}
	}
	
	
	
	$(function(){
		//Initialisation
		init();
	});
	
};