$(function ()
{
    var $form = $('.step-form');
    var $steps = $('.step', $form);
    var $tabs = $('.tabs__tab', $form);
    var $tabContainer = $('.tab-container', $form);
    var currentStep = 1;

    function init(){
        $form.on('stepForm.goTo', function(event, stepName) {
            goTo(stepName);
        });

        $('[data-target]', $form).click(function(event) {
            event.preventDefault();

            var target = event.currentTarget.dataset.target;

            goTo(target);
        });

        $('#checkboxError').hide();

    }

    function goTo(stepName) {
        var targetedStep = parseInt(stepName.replace('step-', ''));

        if (targetedStep === 3 && !isCheckboxChecked()) {
            displayErrorCheckbox();
            return;
        }

        if (!isCurrentStepValid() && targetedStep > currentStep) {
            return;
        }

        if (targetedStep === 2 && $('.street_address')[0]){
            isStreetValid(stepName,targetedStep);
            return;
        }

        updateTabIndicator(stepName);
        updateContent(stepName);

        currentStep = targetedStep;


        window.scroll({ top: $tabContainer.offset().top - 50 });
    }

    function isStreetValid(stepName,targetedStep){
        $('#streetError').hide();
        Web_Contact.verifyStreet($('.street_address').val(),function(result){
            if(result != true){
                displayErrorStreet();
                return false;
            }
            updateTabIndicator(stepName);
            updateContent(stepName);

            currentStep = targetedStep;
            window.scroll({ top: $tabContainer.offset().top - 50 });
        })

    }

    function isCurrentStepValid() {
        var validate = (
            'reportValidity' in HTMLInputElement.prototype
        ) ? 'reportValidity' : 'checkValidity';

        var form = $form[0];
        var currentStepName = form.dataset.currentStep;
        var currentFieldset = form.querySelector('[data-name=' + currentStepName + ']');
        var fields = currentFieldset.querySelectorAll('input[name], select[name], textarea[name]');

        for (var i = 0; i < fields.length; i++) {
            if (!fields[i][validate]()) {
                console.log('Step validation failed at field ' + i + ': ' + fields[i].name);
                return false;
            }
        }

        return true;
    }

    function updateTabIndicator(stepName) {
        $form[0].dataset.currentStep = stepName;
        $tabs.removeClass('tabs__tab--current');
        $tabs.filter('[data-target=' + stepName + ']').addClass('tabs__tab--current');
    }

    function updateContent(stepName) {
        $steps.hide();
        $steps.filter('[data-name=' + stepName + ']').show();
    }

    function isCheckboxChecked() {
        const el = document.getElementsByClassName('visual-checkbox__input');
        let checkboxes = $('.visual-checkbox__input:checked');
        let isChecked = (checkboxes.length > 0);
        $('#checkboxError').hide();

        return isChecked;
    }

    function displayErrorCheckbox() {
        $('#checkboxError').show()
        window.scroll({ top: $tabContainer.offset().top - 50 });
    }

    function displayErrorStreet() {
        $('#streetError').show();
    }

    init();
});
