/**
 * Le controller des categories
 */
petzl.controllers.TechnicalContent = function ()
{
	/**
	 * Cibler ce controller
	 */
	var that = this;
	
	function init(){
		// Parcours les menu pour replier tous sauf le premier
		$('.technicalMenu').each(function(index){
			var innerMenu = $(this).find('.technicalMenuInner');
			innerMenu.attr('data-height', innerMenu.innerHeight());
			
			if(index != 0){
				innerMenu.css('height', '0px');
				$(this).addClass('closed');
				$(this).find('.bigArrowBottom').css({rotate : '-90deg'});
			}
		});
		
		// On attache la taille au ul
		var list = $('.warningContainer').find('ul');
		list.attr('data-height', list.innerHeight());

		// On parcours 
		$('.associatedProduct').each(function(){
			
			// Réduction du texte
			// Récupération du texte
			var text = $(this).find('.productDescription');
			
			dotify(text, 4);
		});
		
		// Handler du click sur un menu fermé
		$('.technicalMenu').click(function(){
			// Si il était fermé
			($(this).hasClass('closed'))
			// On l'ouvre
			? openSideMenu($(this))
			// Sinon on le ferme
			: closeSideMenu($(this));
		});
		
		// Ferme un technical menu
		function closeSideMenu(technicalMenu){
			// On récupère l'intérieur du menu
			var innerMenu = technicalMenu.find('.technicalMenuInner');
			
			// Et on anime
			innerMenu.stop().animate({
				height : 0
			}, 400);
			 
			// On rotate un menu sur le côté
			technicalMenu.find('.bigArrowBottom').stop().transition({rotate : '-90deg'});
			
			// On toggle la classe closed
			technicalMenu.addClass('closed');
		}
		
		// Ouvre un technicalMenu
		function openSideMenu(technicalMenu){
			// On parcours tous les menus
			$('.technicalMenu').each(function(){
				// Et on ferme ceux qui étaient ouvert
				(!$(this).hasClass('closed') && $(this) != technicalMenu) 
				? closeSideMenu($(this)) : null;
			});
			
			// On récupère l'intérieur du menu
			var innerMenu = technicalMenu.find('.technicalMenuInner');

			// Et on anime
			innerMenu.stop().animate({
				height : innerMenu.data('height')+10
			}, 400);
			 
			// On rotate un menu sur le côté
			technicalMenu.find('.bigArrowBottom').stop().transition({rotate : '0deg'});
			
			// On toggle la classe closed
			technicalMenu.removeClass('closed');
		}
		
		// Handler du click sur le warning
		$('.warningContainer').click(function(){
			// On récupère la liste et la taille qu'il faut lui appliquer
			var list = $(this).find('ul');
			var height = (list.hasClass('closed'))
			? list.data('height')
			: 0;
			
			// On anime le contenu
			list.stop().animate({
				height : height
			});
			
			// On toggle la classe
			list.toggleClass('closed');
			
			$('.lessIcon').stop().animate({
				opacity : (	$('.lessIcon').css('opacity') == 0) ? 1 : 0
			}, 300);
			$('.plusIcon').stop().animate({
				opacity : ($('.plusIcon').css('opacity') == 0) ? 1 : 0
			}, 300);
		});

		// Instanciation et init des onglets Advices
		var adviceTabs = new AdviceTab();
		adviceTabs.init();
	}


	function dotify(element, lines){
    	// Réduction du texte
		// Line height du text
		var lineHeight = parseInt(element.css('line-height'), 10);
		if(isNaN(lineHeight)){
			console.log('Line-height non fixé');
		}
		// Hauteur de la div
		var divHeight = element.height();
		// Nombre de lignes résultant
		var nbLines = divHeight / lineHeight;
			
		// Heiht à fixer
		var fixedHeight = lines * lineHeight;
		// On dotdotdot
		element.css('height', fixedHeight);
		element.dotdotdot({
			ellipsis : '...',
			wrap : 'word', 
			height: fixedHeight+'px',
		});
    	
    }
	
	/**
	 * Initialisation
	 */
	init();
	
	
	
};