/**
 * Le controller des categories
 */
petzl.controllers.Team = function ()
{
	var RadioHandler = petzl.views.RadioHandler;

	
	function init(){
		if($('#contentTeamOverview').length){
			
			var radio = new RadioHandler('.teamContainer .teamMate', '.teamOverviewContainer', {
				handleBreadcrumb : true,
				elementToResize : '.teamContainer'
			});
			
			// Click sur un élément select pour l'ouvrir
			$('.select').click(function(){
				openSelect($(this));
			});
			
			// Click sur un des choix du du select
			$('.select .selectChoices span').click(function(){
				var value = $(this).html();
				$(this).parent().parent().find('input').val(value);
				$(this).parent().parent().find('.currentChoice').html(value);
			});
		}
		
		
	}
	
	function detail(){
		if($('.teamDetailContainer').length){
			// On parcours 
			$('.linkedElement').each(function(){
				// Réduction du titre
				// Récupération du titre
				var title = $(this).find('.titleElement');
				
				dotify(title, 2);
				
				
				// Réduction du texte
				// Récupération du texte
				var text = $(this).find('.contentElement');
				
				dotify(text, 4);
			});
		}
	}
	
	// Ouverture du select
	function openSelect(elem) {
		var visibility = (elem.find('.selectChoices').css('display') == 'block') ? 'none' : 'block';
		elem.find('.selectChoices').css('display', visibility).addClass('opened');
	}
	
	function dotify(element, lines){
    	// Réduction du texte
		// Line height du text
		var lineHeight = parseInt(element.css('line-height'), 10);
		if(isNaN(lineHeight)){
			console.log('Line-height non fixé');
		}
		// Hauteur de la div
		var divHeight = element.height();
		// Nombre de lignes résultant
		var nbLines = divHeight / lineHeight;
			
		// Heiht à fixer
		var fixedHeight = lines * lineHeight;
		// On dotdotdot
		element.css('height', fixedHeight);
		element.dotdotdot({
			ellipsis : '...',
			wrap : 'word', 
			height: fixedHeight+'px',
		});
    	
    }
	
	/**
	 * Initialisation
	 */
	init();
	
	detail();
	
};