/**
 * Le controller de la Homepage
 */
petzl.controllers.Contact = function ()
{
	/**
	 * Cibler ce controller
	 */
	var that = this;
	
	/**
	 * Initialisation
	 */
	function init(){

		if(navigator.userAgent.match(/iPad/i) != null){
			$('.contactContainer h1').css('font-size', '45px');
		}
		
		$('.showError').click(function(){
			$('.errorMessage').animate({
				'opacity' : 1
			}, 300);
		});

		/// Click sur le body pour fermer
		$('body').click(function(){
			// Pour chaque select
			$('.select').each(function(){
				// S'il est ouvert
				if($(this).hasClass('opened')){
					// On le toggle (et donc le ferme)
					toggleSelect($(this));
				}
			});
		});
		
		// Click sur un select
		$('.select').click(function(event){
			if(event.preventDefault) event.preventDefault();
			if(event.stopPropagation) event.stopPropagation();
			event.returnValue = false;


			// Pour chaque select
			$('.select').each(function(){
				// Si il est ouvert
				if($(this).hasClass('opened')){
					// On le ferme
					toggleSelect($(this));
				}
			});
			// On ouvre celui là
			toggleSelect($(this));
		});
		
		// Click sur un des choix du du select 
		$('.select .selectChoices span').click(function(event){
			if(event.preventDefault) event.preventDefault();
			if(event.stopPropagation) event.stopPropagation();
			event.returnValue = false;

			var select = $(this).parents('.select');
			var selectChoices = $(this).parents('.selectChoices');

			// On récupère les les valeurs à afficher/changer
			var affichage = $(this).html();
			var value = $(this).data('value');

			// On change/affiche les valeurs
			select.find('input').val(value);
			select.find('.currentChoice').html(affichage);

			// On referme le select
			selectChoices.css('display', 'none');
			select.removeClass('opened');
		});
	};
	
	// Ouverture/Fermeture du select
	function toggleSelect(elem) {
		// On récupère la visibilité du biniou
		var visibility = (elem.find('.selectChoices').css('display') == 'block') ? 'none' : 'block';

		// On toggle sa visbilité
		elem.find('.selectChoices').css('display', visibility);
		elem.toggleClass('opened');
	}
	
	/**
	 * Lancer l'initialisation
	 */
	init();
};


