/**
 * Gestionnaire de zoom
 * 2012/08/28
 * 
 * Utilisation :
 * -----------
 * Thumbs :
 * <img src="" class="zoomInClick" data-zoom="" .. />
 * 
 * 
 */
(function($) {

	// ==== VARIABLES ====
	var windowResizeTimer;
	var animateDelay = 500;
	var imageHeight = 0;
	var zoomContainerHeight = 0;
	var $img;
	var zoomContainerY;
	var zoomContainerIscroll = false;
	
	
	// ==== EVENTS ====
	// On click on thumb
	$('.zoomOnClick').on('click', thumbOnClick);
	$('.zoomContainer').on('click', hideZoom);
	
	
	/**
	 * Thumb on click
	 */
	function thumbOnClick(event){
		var $image = $(this);
		console.log($image);
		var zommedImageSource = $image.attr('data-zoom'); 
		
		showZoom(zommedImageSource);
	}
	
	
	/**
	 * Show zoom
	 * @param Image à afficher
	 */
	function showZoom(zoomedImageSource){
		var $zoomContainer = $('.zoomContainer'); 
		
		// Event Resize
		$(window).bind('resize', windowResizeHandler);
		$(window).bind('orientationchange', windowResizeHandler);
		
		// Overflow body
		$('body').css({'overflow':'hidden'});
		$('.touch body').on('touchmove', touchBodyTouchMove);
		
		
		// Cache les éléments en hideOnZoom
		$('.hideOnZoom').stop().animate({
			'opacity':0
		},animateDelay);
		
		// Prepare le zoom à s'afficher
		$zoomContainer.css({
			'opacity':0,
			'display': 'block'
		});
		
		// Positionne le zoom
		positionZoom();
		
		
		// Affiche le zoom
		$zoomContainer.stop().animate({
			'opacity':1
		}, {duration: animateDelay});

		
		// Charge l'image
		loadImage(zoomedImageSource);
	}
	
	/**
	 * .Touch body : on touch
	 */
	function touchBodyTouchMove(event){
		event.preventDefault();
	}
	
	/**
	 * Load image
	 */
	function loadImage(zoomedImageSource){
		var $zoomContainer = $('.zoomContainer'); 
		$('<img />').attr('data-tooltip','- zoom').attr('src', zoomedImageSource).load(function(){
			$img = $(this);
			$zoomContainer.find('.scroller').append($img);
			$img.tooltip();
			imageHeight = $img.height();
			
			
			if(Modernizr.touch){
				zoomContainerIscroll = new iScroll('zoomContainer',{vScrollbar: false});
			} else {
				$zoomContainer.bind('mousemove', mousemoveHandler);
			}
			
			centerImage();
		});
	}
	
	/**
	 * Hide zoom
	 */
	function hideZoom(){
		var $zoomContainer = $('.zoomContainer'); 
		
		// Off Event resize
		$(window).unbind('resize', windowResizeHandler);
		$(window).unbind('orientationchange', windowResizeHandler);
		
		if(zoomContainerIscroll != false) zoomContainerIscroll.destroy();
		
		$zoomContainer.find('.scroller img').remove();
		
		// Cache le zoom
		$zoomContainer.stop().animate({
			'opacity':0,
			'height': 0
		}, (animateDelay/2),function(){
			$(this).hide();
			
			// Body overflow
			$('body').css({'overflow':'auto'});
		});

		// Affiche les elements qui étaient cachés
		$('.hideOnZoom').stop().animate({
			'opacity':1
		},(animateDelay/2));
		
		$('.touch body').off('touchmove', touchBodyTouchMove);
	}
	
	
	/**
	 * Positionne les containeur du zoom
	 */
	function positionZoom(){
		// Scrool top
		var documentBody = (($.browser.chrome)||($.browser.safari)) ? document.body : document.documentElement;
		$(documentBody).animate({scrollTop: 0}, 0);
		
		var $zoomContainer = $('.zoomContainer'); 
		zoomContainerY = $zoomContainer.offset().top;
		
		var windowHeight = window.innerHeight || $(window).height();
		zoomContainerHeight = windowHeight - zoomContainerY;
		$zoomContainer.css({height:zoomContainerHeight+'px'});

		// Refresh Iscroll
		if(zoomContainerIscroll != false){
			zoomContainerIscroll.refresh();
		}
	}
	
	
	/**
	 * Window Resize Handler
	 */
	function windowResizeHandler(){
		if(windowResizeTimer) window.clearTimeout(windowResizeTimer);
		windowResizeTimer = window.setTimeout(positionZoom, 250);
	}
	
	
	/**
	 * Mouse move handler
	 */
	function mousemoveHandler(event){
		// Image plus grande que le container
		if(imageHeight >= zoomContainerHeight){
			
			// Marges
			var margin = zoomContainerHeight * 0.25;
			
			// Ratio entre 0 et 1
			var ratioY = ((event.pageY - zoomContainerY) - margin) / (zoomContainerHeight - (2 * margin));
			
			// Position top
			var imageTop = (zoomContainerHeight - imageHeight) * ratioY;
		
			
			$img.css({
				top : imageTop,
				'margin-top' : 0
			});
			
		}
		// Image plus petite que le container
		else {
			centerImage();
		}
	}

	/**
	 * Center image
	 */
	function centerImage(){
		var zoomContainerHeight = $('.zoomContainer').height();
		
		if(imageHeight < zoomContainerHeight){
			var imageTop = (zoomContainerHeight - imageHeight) / 2;
				
			if(zoomContainerIscroll != false){
				$img.css({
					'margin-top' : imageTop+'px'
				});
			} else {
				$img.css({
					top : imageTop,
					'margin-top' :0
				});
			}
		} else {
			$img.css({
				'margin-top' :0,
				'top' :0
			});
			
		}
		
	}
	
	
})(jQuery);