/**
 * Tool Tips
 * par Jay Salvat - http://blog.jaysalvat.com/*/
(function($) {
$.fn.tooltip = function(settings) {
    options =  {
        offsetX:  5,    // positionnement X par rapport au pointeur
        offsetY:  5,    // positionnement Y par rapport au pointeur
        baseLine: 'top', // alignement de par rapport au pointeur
        delay:    0,   // délai avant l'ouverture de l'infobulle
        click:    true,   // autorise ou non le clic sur le lien
        cls : '',
        contentOnChild : false
    };
    var options = $.extend(options, settings); 

    return this.each(function(){
        var $$ = $(this);
        var aTitle   = $$.attr('title') || '';
        var aHref    = $$.attr('href')  || '';
        var aRel     = $$.attr('rel')   || '';
        var aToolTip = $("<div></div>");
        var aCaption = '';
        var timer;
        var offsetX = 10;
        var offsetY = 25;
        var orientationDelta = 0;
        
        if(!Modernizr.touch)
        {
        	// Quand le curseur survole un élément
            $$.mouseover(function(e) {
                // Supprime le Title pour éviter le toolTip par défaut du navigateur
                $$.attr('title', '');    
                $('.tooltipText').remove();
                
            	if($$.is('[data-tooltip]'))
            	{
            		aTitle = $$.attr('data-tooltip');
            	}
            	
            	if(options.contentOnChild)
            	{
            		aTitle = $$.find('.data-tooltip').html();
            	}
            	
            	
                // mode texte
                if (aTitle != '') {
                    aToolTip = $('<div class="label tooltipText '+options.cls+'">'+ aTitle +'</div>');
                } 

                // Le toolTip précédemment créé est ajouté au Body et masqué
                aToolTip.appendTo("body").hide().css({ position:'absolute', top:0, left:0 });
                
                
                
                // On déplace le toolTip en même temps que la souris
                $$.mousemove(function(e) {
                	if($(window).width() < (e.pageX + offsetX + aToolTip.width())){
                		orientationDelta = -(aToolTip.width() + (2*offsetX));
                	} else {
                		orientationDelta = 0;
                	}
                    aToolTip.css({
                        left: e.pageX + offsetX + orientationDelta +"px",
                        top:  e.pageY + offsetY + "px"
                    });
                }); 
                
                

                // On attend quelques fractions de seconde avant d'afficher le toolTip
                timer = window.setTimeout( function() { aToolTip.show(); }, options.delay);
            });

            // Quand le curseur ne survole plus un élément
            $$.on('mouseleave', function(e) {
                clearTimeout(timer);
                // On remet le Title en place
                if(!options.contentOnChild) $$.attr("title", aTitle);
                // On supprime le suivi de déplacement
                $$.unbind("mousemove");
                // On supprime le toolTip
                //aToolTip.remove();
                
                
                timer = window.setTimeout( function() {
                    // On supprime le toolTip
                    aToolTip.remove();
                    clearTimeout(timer);
                }, 50);
            }); 

            // Bloque éventuellement le clic sur le lien
            $$.click(function() {
               return options.click;
            });
        }
    });
};
})(jQuery);