var ProductCTRL =
{
	pageRef : null,
	initFunc : function()
	{
		
		/**
		 * Cibler ce controller
		 */
		var that = this;

		var popinBuyOnline = null;
		
		// DOM elements
		$body = $('body, html');
		
		// SLIDESHOW : Variables
		
		// ZOOM : Variables
		var windowResizeTimer;
		var animateDelay = 500;
		var imageHeight = 0;
		var zoomContainerHeight = 0;
		var $img;
		var zoomContainerY;
		var zoomContainerIscroll = false;
		
		// NAVIGATEUR : Test
		if (/chrome/gi.test(navigator.userAgent.toLowerCase()))
		{
			var isChrome = true;
		}
		
		// ARROW CHANGE ZOOM : Array des data-zoom
		var zoomedOverview = [];
		
		// MINI OVERVIEW SLIDER
		var thumbRange = 0;
		var currentRange = 1;
		var miniOverviewContainerHeight = 0;
		
		/**
		 * Inititialisation 
		 */
		function init(){

			$.address.change(function(event) {  

				if(event.value == '/' + $('#buyonlineLabel').html()) {
					openPopinBuyOnline();
				}
				else {

					if(popinBuyOnline) {
						$.colorbox.close();
					}

				}

			}); 

			// On initialise le lancement de la colorbox
			$('.popinBuyOnline').click(function(event){
				event.preventDefault();
				//shalom
				var buyonlineLabel = $('#buyonlineLabel').html();
				$.address.value(buyonlineLabel);  
			});
			
			// On parcours les produits associés
			$('.associatedProduct').each(function(){
				// Réduction du titre
				// Récupération du titre
				var title = $(this).find('.productTitle');
				
				dotify(title, 2);

				
				// Réduction du texte
				// Récupération du texte
				var text = $(this).find('.productDescription');
				
				dotify(text, 4);
			});
			
			// ARROW CHANGE ZOOM : Récupération des data-zoom
			$('.overviewSelected .slide .zoomOnClick').each(function(){
				zoomedOverview.push($(this).data('zoom'));
			});
			
			
			// PRODUCT MENU : Récupération du menu et de son offset
			var productMenu = new FixedMenu('#productMenu', 60);
			
			// SLIDESHOW : Initialisation du slideshow et des thumbs
			var slideshow = new petzl.views.ClassicSlideshow('#slideshow', {
				autoStart: false,
				index: 1,
				opacityAnimation : true,
				transitionDuration: 500
			});

			var selector = new petzl.views.ThumbsSelector('#slideshow .thumbsContainer', {
				intro: false,
				index: 1,
				alpha : true,
			});
			
			
			// Ecouter les changements de slide sur le slideshow
			slideshow.onChange = function (pIndex){
				// Appliquer sur le selecteur et sur l'autre slideshow
				selector.select(pIndex);
			};

			// Ecouter les changements de slide sur le selecteur
			selector.onChange = function (pIndex){
				// Appliquer sur les slideshow
				slideshow.select(pIndex);
				
				var thumbs = $('.thumbsContainer .thumb');
				thumbs.each(function(i){
					$(this).css({
						opacity: pIndex-1 == i ? 1 : 0.5
					});
				});
			};
			
			// DESCRIPTION ELLIPSIS : Ellipse de la description du produit pour tous les navigateurs
			var textContainer = $('.productCaracteristiquesPosition');
			var text = $('.productCaracteristiquesPosition .productCaracteristiques');

			var lineHeight = parseInt(text.css('line-height').replace('px', ''));
			var divHeight = text.height();
			var nbLines = divHeight / lineHeight;
			
			if(nbLines > 7){
				var fixedHeight = 7 * lineHeight;
				textContainer.css('height',fixedHeight);
				$('.productCaracteristiquesPosition').dotdotdot({
					ellipsis : '...',
					wrap : 'word', 
					height: fixedHeight+'px',
					after: '.productDescription .arrowLink'
				});
			}else{
				$('.productDescription .arrowLink').css('display', 'none');
			}
			
			// OVERVIEW TOOLTIP : Initialise les tooltips
			if($('#content').hasClass('MarketPro')){
				$('.tooltip').tooltip({
					cls: 'labelPro'
				});
			} else{
				$('.tooltip').tooltip();
			}
			
			// MINI OVERVIEW :  Initialisation du nombre de rangée de thumb
			thumbRange = Math.ceil($('.miniOverviewContainer ul li.thumb').length / 4);
			miniOverviewContainerHeight = $('.miniOverviewContainer ul').height();
			
			

			// taille thumbsnail
			thumbContainerHeight = $('.miniOverviewContainer .thumbsContainer').height();
			thumbHeight = (thumbContainerHeight / 4) - 5;
			$('.miniOverviewContainer ul li.thumb').height(thumbHeight);
			$('.miniOverviewContainer ul li.thumb').width(59);
			
			

		}

		function openPopinBuyOnline(){
			// POPIN ACHETER EN LIGNE
			// On initialise le lancement de la colorbox
			var mustClose = false;
			popinBuyOnline = 
				$.colorbox({
				//href:$('.popinBuyOnline').data('popin'), //uncomment this before release
				href : '#popinBuyOnlinePopUp',
				transition: "none",
				inline: true,
				overlayClose : true, 
				closeButton : false,
				onClosed : function(e){
					if (mustClose){
						location.href = location.href.replace(location.hash,""); 
						return;
					}
					$('.popinContent.popinContent-notifyMe').hide();
					$('.popinContent.popinContent-thankyou').hide();
					$('.popinContent.popinContent-buyonline').show(); 
					
					$('.notLoggedBlock').css("height",'');
					$.address.value(''); 
					
					if(ProductCTRL.pageRef != null && ProductCTRL.pageRef != 'undefined')
					{
						ProductCTRL.pageRef = ProductCTRL.pageRef.indexOf('#') != -1 ? ProductCTRL.pageRef.split('#')[0] : ProductCTRL.pageRef;
						window.location.replace(ProductCTRL.pageRef);
						ProductCTRL.pageRef = null;
					}
				},
				onComplete : function()
				{
					ProductCTRL.initOnComplete();					
				},
				// Haim 17-02-2016
				onCleanup : function(){
					if($('.popinContent-thankyou').is(':visible')){
						mustClose = true;
					}else{
						mustClose = false;
					}
				}
			});
		}
		
		/**
		 * Fonction regroupant tous les listeners
		 */
		function listener(){
			
			
			// DESCRIPTION ELLIPSIS  : Clic sur le "Lire la suite" de la description produit
			$('.productDescription .arrowLink').click(function(event){
				
				// Annuler la propagation de l'event (gère IE)
				event.preventDefault ? event.preventDefault() : event.returnValue = false;
				
				// Récupération du container et du texte qu'il contient
				var container = $('.productCaracteristiquesPosition');
				var text = container.find('p');
				var link = $(this);
				
				// On récupère le contenu précédemment cut
				container.trigger("originalContent", function(content) {
					// On vide et on append tout le contenu
					text.html('');
					text.append(content);
				});
				
				// Récupération de la nouvelle height 
				var height = text.height();

				
				// Animation de la nouvelle taille du texte
				$('.productCaracteristiquesPosition').stop().animate({
					height : height
				}, 500, function(){
						// Indiquer que le body à changer de taille
						$('body').trigger('heightChange');
				});
				
				// Disparition du lien 'Lire la suite'
				link.stop().animate({
					opacity : 0
				}, 200, function(){
					link.css('display','none');
				});
			});

			// ZOOM : Click sur l'image pour déclencher le zoom
			$('.zoomOnClick').on('click', thumbOnClick);
			$('.zoomContainer').on('click', hideZoom);
			
			// MINI OVERVIEW SLIDER
			$('.miniOverviewContainer .thumbTop').click(function(){
				if(currentRange > 1){
					var marginTop = parseInt($('.miniOverviewContainer ul li.thumb').first().css('margin-top').replace('px',''));
					$('.miniOverviewContainer ul li.thumb').first().stop().animate({
						marginTop :  marginTop + miniOverviewContainerHeight
					}, 400);
					currentRange--;
				}
			});
			
			$('.miniOverviewContainer .thumbBottom').click(function(){
				if(currentRange < thumbRange){
					var marginTop = parseInt($('.miniOverviewContainer ul li.thumb').first().css('margin-top').replace('px',''));
					$('.miniOverviewContainer ul li.thumb').first().stop().animate({
						marginTop : marginTop -miniOverviewContainerHeight
					}, 400);
					currentRange++;
				}
			});


			if(navigator.userAgent.match(/iPad/i) == null && navigator.userAgent.match(/Android/i) == null){
				// Hover sur le overview selected pour faire apparaitre la description
				$('.overviewSelected  .slide').hover(function(){
					// On récupère les élèments 
					var slide = $(this);
					var slideInfo = slide.find('.slideInfo');
					var slideText = slide.find('.slideText');
					var borders = slide.find('.borders div');

					// Variable de delay
					var delay = 0;

					slideInfo.css({
						'display' : 'block',
						
					}).animate({
						'opacity' : 1
					}, 300);

					// On récupère la taille de l'image + la taille du texte
					var height = slide.find('.zoomOnClick').outerHeight() + slideText.innerHeight();

					slideInfo.css({
						height : height
					});
					// Pour chaque border
					/*borders.each(function(){
						// On récupère le border
						var border = $(this);

						// Après que le dernier border soit animé
						setTimeout(function(){
							// On anime le border
							border.stop().animate({
								// En largeur pour en haut et en bas
								'width' : (border.index() %2 == 0) ? '100%' : '5px',
								// En hauteur pour la gauche et la droite
								'height' : (border.index() %2 != 0) ? '100%' : '5px'
							}, 100);
						}, delay);

						// On update le delay
						delay = delay + 100;
					});
					*/

					// Après que tout ai été animé
					setTimeout(function(){
						slideText.stop().css('display', 'block').animate({
							opacity : 1
						}, 400);
					}, delay);

				}, function(){
					// On récupère les élèments 
					var slide = $(this);
					var slideInfo = slide.find('.slideInfo');
					var slideText = slide.find('.slideText');
					var borders = slide.find('.borders div');

					slideInfo.stop().animate({
						opacity : 0
					}, 400, function(){
						slideInfo.css('display', 'none');

						/*borders.css({
							width : 0,
							height : 0
						});*/
					});
				});
			}
		}
		
		
		/**
		 * Thumb on click
		 */
		function thumbOnClick(event){
			// On récupère l'élément sur lequel on a cliqué et son image de zoom
			var $image = $(this);
			var zoomedImageSource = $image.attr('data-zoom'); 
			
			showZoom(zoomedImageSource);
		}
		
		
		/**
		 * Show zoom
		 * @param Image à afficher
		 */
		function showZoom(zoomedImageSource){
			var $zoomContainer = $('.zoomContainer'); 
			
			// Event Resize
			$(window).bind('resize', windowResizeHandler);
			$(window).bind('orientationchange', windowResizeHandler);
			
			// Overflow body
			$('body').css({'overflow':'hidden'});
			$('.touch body').on('touchmove', touchBodyTouchMove);
			
			
			// Cache les éléments en hideOnZoom
			$('.hideOnZoom').stop().animate({
				'opacity':0
			},animateDelay);
			
			// Prepare le zoom à s'afficher
			$zoomContainer.css({
				'opacity':0,
				'display': 'block'
			});

			// On calcul où on positionne le zoom container
			if($('#headerBottom').parent().hasClass('fixed')){
				$zoomContainer.css('top', '40px');
			}
			
			// Positionne le zoom
			positionZoom();
			
			// Affiche le zoom
			$zoomContainer.stop().animate({
				'opacity':1
			}, {duration: animateDelay});

			
			// Charge l'image
			loadImage(zoomedImageSource);
			
			// Récupération de l'index de l'image courante
			var index = $.inArray(zoomedImageSource, zoomedOverview);
			
			// BINDING KEY EVENT : Flèche gauche ou droite
			$(document).keydown(function(e){
				if (e.keyCode == 37 && index-1 >= 0) { 
					index--;
					changeImage(index);
					
				}
				if (e.keyCode == 39 && index+1 <= zoomedOverview.length-1) { 
					index++;
					changeImage(index);
				}
			});
		}
		
		function changeImage(index){
			$('#scroller').empty();
			loadImage(zoomedOverview[index]);
		}
		
		/**
		 * .Touch body : on touch
		 */
		function touchBodyTouchMove(event){
			event.preventDefault();
		}
		
		/**
		 * Load image
		 */
		function loadImage(zoomedImageSource){
			var $zoomContainer = $('.zoomContainer'); 
			$('<img />').attr('data-tooltip','ZOOM -').attr('src', zoomedImageSource).load(function(){
				$img = $(this);
				$zoomContainer.find('.scroller').append($img);
				$zoomContainer.css('height', '100%');
				if($('#content').hasClass('MarketPro')){
					$img.tooltip({
						cls: 'labelPro'
					});
				} else{
					$img.tooltip();
				}
				
				imageHeight = $img.height();
				// Si tablette 
				if( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
					$img.addClass('tablet');
				}
				
				
				if(Modernizr.touch){
					zoomContainerIscroll = new iScroll('zoomContainer',{vScrollbar: false});
				} else {
					$zoomContainer.bind('mousemove', mousemoveHandler);
				}
				
				centerImage();
			});
		}
		
		/**
		 * Hide zoom
		 */
		function hideZoom(){
			var $zoomContainer = $('.zoomContainer'); 
			
			// Off Event resize
			$(window).unbind('resize', windowResizeHandler);
			$(window).unbind('orientationchange', windowResizeHandler);
			
			if(zoomContainerIscroll != false) zoomContainerIscroll.destroy();
			
			$zoomContainer.find('.scroller img').remove();
			
			// Cache le zoom
			$zoomContainer.stop().animate({
				'opacity':0,
				'height': 0
			}, (animateDelay/2),function(){
				$(this).hide();
				
				// Body overflow
				$('body').css({'overflow':'auto'});
			});

			// Affiche les elements qui étaient cachés
			$('.hideOnZoom').stop().animate({
				'opacity':1
			},(animateDelay/2));
			
			$('.touch body').off('touchmove', touchBodyTouchMove);
		}
		
		
		/**
		 * Positionne les containeur du zoom
		 */
		function positionZoom(){
			// Scrool top
			var documentBody = document.documentElement;
			$(documentBody).animate({scrollTop: 0}, 0);
			
			var $zoomContainer = $('.zoomContainer'); 
			zoomContainerY = $zoomContainer.offset().top;
			
			var windowHeight = window.innerHeight || $(window).height();
			zoomContainerHeight = windowHeight - zoomContainerY;
			$zoomContainer.css({height:zoomContainerHeight+'px'});

			// Refresh Iscroll
			if(zoomContainerIscroll != false){
				zoomContainerIscroll.refresh();
			}
		}
		
		
		/**
		 * Window Resize Handler
		 */
		function windowResizeHandler(){
			if(windowResizeTimer) window.clearTimeout(windowResizeTimer);
			windowResizeTimer = window.setTimeout(positionZoom, 250);
		}
		
		
		/**
		 * Mouse move handler
		 */
		function mousemoveHandler(event){
			// Image plus grande que le container
			if(imageHeight >= zoomContainerHeight){
				
				// Marges
				var margin = zoomContainerHeight * 0.25;
				
				// Ratio entre 0 et 1
				var ratioY = ((event.pageY - zoomContainerY) - margin) / (zoomContainerHeight - (2 * margin));
				
				// Position top
				var imageTop = (zoomContainerHeight - imageHeight) * ratioY;
			
				
				$img.css({
					top : imageTop,
					'margin-top' : 0
				});
				
			}
			// Image plus petite que le container
			else {
				centerImage();
			}
		}

		/**
		 * Center image
		 */
		function centerImage(){
			var zoomContainerHeight = $('.zoomContainer').height();
			
			// Centrer horizontalement
			var marginLeft = ($('.zoomContainer .scroller img').width()) / 2;
			var marginLeftTablet = ($('.zoomContainer .scroller img').width()) / 20;
			$img.css({
				'margin-left' : -marginLeft+'px'
			});
			$('.tablet').css({
				'margin-left' : -marginLeftTablet+'px',
				'max-width' : 980+'px'
			});
			
			if(imageHeight < zoomContainerHeight){
				var imageTop = (zoomContainerHeight - imageHeight) / 2;
					
				if(zoomContainerIscroll != false){
					$img.css({
						'margin-top' : imageTop+'px'
					});
				} else {
					$img.css({
						top : imageTop,
						'margin-top' :0
					});
				}
			} else {
				$img.css({
					'margin-top' :0,
					'top' :0
				});
				
			}
			
		}
		
		function dotify(element, lines){
			// Réduction du texte
			// Line height du text
			var lineHeight = parseInt(element.css('line-height'), 10);
			if(isNaN(lineHeight)){
				console.log('Line-height non fixé');
			}
			// Hauteur de la div
			var divHeight = element.height();
			// Nombre de lignes résultant
			var nbLines = divHeight / lineHeight;
				
			// Heiht à fixer
			var fixedHeight = lines * lineHeight;
			// On dotdotdot
			element.css('height', fixedHeight);
			element.dotdotdot({
				ellipsis : '...',
				wrap : 'word', 
				height: fixedHeight+'px',
			});
			
		}
		
		/**
		 * Lancement de l'initialisation
		 */
		init();
		
		/**
		 * Lancer les listener
		 */
		listener();
		
	},
	
	initOnComplete : function()
	{	
        var $notifyme = $('.popin.popinNotifyMe');
        if ($notifyme.length > 0){
            $notifyme.find('input#Firstname').parent().next('[class*=errorLabel]').html(v_message_first_name_required);
            $notifyme.find('input#LastName').parent().next('[class*=errorLabel]').html(v_message_last_name_required);
            $notifyme.find('input#Email').parent().next('[class*=errorLabel]').html(v_message_email_required);
        }

		$('#cboxContent').css('width', $('#cboxContent').find('.popin').outerWidth());		
		$('#cboxContent,#colorbox,#cboxWrapper').attr('style', function(i,s) { return s + 'height: 1px!important;' });


		// Dotify pour le nom du produit
		$('.ProductInfo_description .productName').css('line-height', '34px');
		dotify($('.ProductInfo_description .productName'), 2);
		
		// Initialisation des selects
		$.Select();

		$('.cross').unbind('click');
		$('.cross').click(function()
		{
			$.colorbox.close();
		});
		
		// Si on est sur iOS 
		if ( navigator.userAgent.match(/(iPad|iPhone|iPod)/g))
		{
			// On ajoute la classe au container
			$('#colorbox').addClass('ios');
		} 


		var notifyOpened = false;
		$('.popinThankYouLogin').unbind('click');
		$('.popinThankYouLogin').click(function(){
				var prodUrl = location.href.split('#')[0];
				var productId = $('.petzlProduct').val() ;
				var accountId = $('.accountId').val();
				var prodDesc = $('.productDesc').val();
				var currentSKUInvName = $('#currentSKUInvName').text().trim();
				if(accountId !='' && productId!=''){
					Web_Product.createProductNotificationLogin(accountId,productId,prodUrl,currentSKUInvName,prodDesc,function(result, event)
					{
						if(result)
						{				
					
							$('.notLoggedBlock_buttons .BtnError').hide();												
							var pResult = {responseText:' '};
							pResult.responseText =  $('#popinThankYou');
							
							// On append le contenu à la page
							$('.popinContent-thankyou').append(pResult.responseText);

							// On cache la popin buyonline
							$('.popinContent-buyonline').fadeOut(300);

							// On montre la popin notify
							$('.popinContent-thankyou').fadeIn(300);

							$('body').stop().animate({scrollTop: '0px'}, 400);

							$('.Btn-close').click(function(event){

								event.preventDefault();

								$.colorbox.close();
							});
						}
					});
					
				}
			});


//
		$('.popinNotifyme').unbind('click');
		$('.popinNotifyme').click(function(event)
		{
			$('#activityDetail').appendTo($('#activityDetailTarget'));
			event.preventDefault();
			var firstRun = true;

			if(!notifyOpened)
			{
				notifyOpened = true;
				//if(result){
				var pResult = {responseText:' '};
				pResult.responseText =  $('#popinNotify');

				// Vérifier le status
				// On append le contenu à la page
				$('.popinContent-notifyMe')
					.append(pResult.responseText);
				if ($('.popinNotifyMe').length > 1){
					$('.popinNotifyMe').first().remove();
					$('.ActivityWrapper_errorLabel').hide();
				}
					

				// On cache la popin buyonline
				$('.popinContent-buyonline').fadeOut(300);

				// On montre la popin notify
				$('.popinContent-notifyMe').fadeIn(300);

				function check(checkbox)
				{
					var newOpacity = checkbox.css('opacity') == 0 ? 1 : 0;
					checkbox.animate(
					{
						opacity : newOpacity
					}, 200);
					
					var checkboxInput = checkbox.parent().find('input');
					var check = (newOpacity != 1);
					checkboxInput.prop('checked', check).change();
				}

				$('input[type=checkbox]').each(function()
				{
					 $(this).parent().find('.fakeCheckbox').addClass('ieCompatibility');
					 if (navigator.appName == 'Microsoft Internet Explorer')
					 {
						 $(this).css('margin-top', '0px');
					 }

					 // Si elle sont déjà cochées, on met à jour l'affichage.
					 if(this.checked) {
						 var checkbox = $(this).parent().find('.fakeCheckbox');
						 check(checkbox);
					 }

				});
				
				$('.checkbox label').unbind('click');
				$('.checkbox label').click(function()
				{
					var checkbox = $(this).parent().find('.fakeCheckbox');
					check(checkbox);
				});
				
				$('.ieCompatibility').unbind('click');
				$('.ieCompatibility').click(function()
				{
					check($(this));
				});
				
			//ver .19
				// On cache le block login en sauvegardant sa taille
				var removeError = false;
				if(!$('.InputContainer_input').hasClass('InputText-error')) {
					$('.InputContainer_input').addClass('InputText-error');
					removeError = true;
				}
				$('.loginBlock').data('height', $('.loginBlock').innerHeight()).css('height', 0);
				if(removeError) {
					$('.InputContainer_input').removeClass('InputText-error');
				}
			//End ver .19
										
										

				// On cache le block login en sauvegardant sa taille
				//console.log($('.loginBlock').innerHeight());
				//$('.loginBlock').data('height', $('.loginBlock').innerHeight()).css('height', 0);

				// Au clock sur le lien pour se logger
				$('.LinkNotifyLogIn').unbind('click');
				$('.LinkNotifyLogIn').click(function(event)
				{
					event.preventDefault();

					$('.notLoggedBlock').animate(
					{
						'height' : 0
					});
					
					$('.loginBlock').animate(
					{
						height : $('.loginBlock').data('height')
					});


				});
										
										
				//MY 22.07.2015  add validtions 
				var checkCheckBox = function()
				{
					if($('.InputGroup input').is(":checked"))
					{
						$('.ActivityWrapper_errorLabel').hide();
						return true;
					}
					else
					{
						$('.ActivityWrapper_errorLabel').show();
						return false;
					}
					
				};
				
				var checkIfEmpty =function(selector)
				{
					
					if(selector.val() ==null || selector.val() == '')
					{
						selector.parent().addClass('InputText-error');
						return false;
					}
					else
					{
						selector.parent().removeClass('InputText-error');
						return true;
					}
				};	
														
				var checkMail = function(selector)
				{
					if(!selector.val()){
						selector.parent().addClass('InputText-error');
						selector.parent().next().html(v_message_email_required);
						return false;
					}
					if(!validateEmail(selector.val())){
						selector.parent().addClass('InputText-error');
						selector.parent().next().html(v_message_email);
						return false;
					}
					selector.parent().removeClass('InputText-error');
					return true;
				};
				
				function validateEmail(email) 
				{
					var re = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
					return re.test(email);
				}
				
				function validateFrom(noValidateActivities)
				{
					if((!noValidateActivities && checkCheckBox()  || !!noValidateActivities) && checkIfEmpty($( "input[id='LastName']" )) && checkIfEmpty($( "input[id='Firstname']" ))  && checkMail($( "input[id='Email']" )))
						$('.notLoggedBlock_buttons .BtnError').hide();
					else
						$('.notLoggedBlock_buttons .BtnError').show();
				}
				
				function validateLogInFrom()
				{
					if(checkIfEmpty($("input[id='PassLoginBlock']")) && checkMail($("input[id='PassLoginBlock']")))
					{
						$('.LogInBlock_buttons .BtnError').hide();
					}
					else
					{
						$('.LogInBlock_buttons .BtnError').show();
					}
				}
										
				//MY guest block
				$( "input[id='Firstname']" ).blur(function(){if (!firstRun) {checkIfEmpty($( "input[id='Firstname']" ));validateFrom(true);}});
				$( "input[id='LastName']" ).blur(function(){if (!firstRun) {checkIfEmpty($( "input[id='LastName']" ));validateFrom(true);}});
				$( "input[id='Email']" ).blur(function(){if (!firstRun) {checkMail($( "input[id='Email']" ));validateFrom(true);}});
				$('.InputGroup input').change(function(){if (!firstRun) {checkCheckBox();validateFrom(true);}});
				
				//MY login block
				$("input.EmailLoginBlock").blur(function(){checkMail($("input.EmailLoginBlock"))});
				$("input.PassLoginBlock").blur(function(){checkIfEmpty($("input.PassLoginBlock"))});
				

				
				$('.popinThankYou.popinThankYouBtn').unbind('click');
				$('.popinThankYou.popinThankYouBtn').click(function(event)
				{
					firstRun = false;
					//ADD MY the if in order to check validtion 
					event.preventDefault();
					//if(checkCheckBox() && checkIfEmpty($( "input[id='LastName']" )) & checkMail($( "input[id='Email']" ))){TODO-to return when I have activity list!
					if(checkIfEmpty($( "input[id='LastName']" )) & checkIfEmpty($( "input[id='Firstname']" )) & checkMail($( "input[id='Email']" )) & checkCheckBox())
					{				
						
						var FirstName = $('.InputLogin .InputContainer .InputContainer_input #Firstname').val();
						var LastName = $('.InputLogin .InputContainer .InputContainer_input #LastName').val();
						var Email = $('.InputLogin .InputContainer .InputContainer_input #Email').val();

						//dummyClass2-select   checkboxContainerClass2-select

						var Market__C = '';
						var Market__C2 = '';

						$('[id$=subMarketsList_selected] option').each(function(){
							if ($(this).closest('.dummyClass2-select').length > 0)
								Market__C += ';'+$(this).text();
							else
								Market__C2 += ';'+$(this).text();
						});

						if (!!Market__C)
						{
							Market__C = Market__C.substring(1);
						}

						if (!!Market__C2)
						{
							Market__C2 = Market__C2.substring(1);
						}
						
						var prodUrl = location.href;

						//$(this).hide();
						$(this).unbind('click');

						/////////
						createProductNotificationGuest(prodUrl, LastName, FirstName, Email, Market__C, Market__C2);
						
					}
					else
					{
						var $errorLabel = $('.notifyForm').find('.InputText_errorLabel:visible').first();
						$('.notLoggedBlock_buttons .BtnError').show().html($errorLabel.text() || $('.notifyForm .ActivityWrapper_errorLabel:visible').text());
						$errorLabel.prev().children('input').focus();
					}
					//$('.popinThankYou').unbind('click');
				});			
			}
		});

	},
	
	afterLead :function(pageRef){
	
				
		ProductCTRL.pageRef = pageRef;
	
		$('.notLoggedBlock_buttons .BtnError').hide();												
		var pResult = {responseText:' '};
		pResult.responseText =  $('#popinThankYou');
		
		// On append le contenu à la page
		$('.popinContent-thankyou').append(pResult.responseText);

		// On cache la popin buyonline
		$('.popinContent-notifyMe').fadeOut(300);

		// On montre la popin notify
		$('.popinContent-thankyou').fadeIn(300);

		$('body').stop().animate({scrollTop: '0px'}, 400);

		$('.Btn-close').click(function(event){

			event.preventDefault();
			
			$.colorbox.close();
		});
	},

	createNotificationCookies: function(){

		var prodUrl = location.href.split('#')[0];
		var productId = $('.petzlProduct').val() ;
		var prodDesc = $('.productDesc').val();
		var currentSKUInvName = $('#currentSKUInvName').text().trim();

		$.cookie("apex__notification_prodUrl",prodUrl,{ path: '/' });
		$.cookie("apex__notification_productId",productId,{ path: '/' });
		$.cookie("apex__notification_prodDesc",prodDesc,{ path: '/' });
		$.cookie("apex__notification_currentSKUInvName",currentSKUInvName,{ path: '/' });

	}
};
ProductCTRL.initFunc();


	
	
	