/**
 * Le controller de la Homepage
 */
petzl.controllers.Product = function ()
{
	/**
	 * Cibler ce controller
	 */
	var that = this;
	
	// DOM elements
	$body = $('body, html');
	
	// SLIDESHOW : Variables
	var ClassicSlideshow = petzl.views.ClassicSlideshow;
	var ThumbsSelector = petzl.views.ThumbsSelector;
	//var FixedMenu = petzl.views.FixedMenu;
	
	// ZOOM : Variables
	var windowResizeTimer;
	var animateDelay = 500;
	var imageHeight = 0;
	var zoomContainerHeight = 0;
	var $img;
	var zoomContainerY;
	var zoomContainerIscroll = false;
	
	// NAVIGATEUR : Test
	if (/chrome/gi.test(navigator.userAgent.toLowerCase()))
	{
		var isChrome = true;
	}
	
	// ARROW CHANGE ZOOM : Array des data-zoom
	var zoomedOverview = [];
	
	// MINI OVERVIEW SLIDER
	var thumbRange = 0;
	var currentRange = 1;
	var miniOverviewContainerHeight = 0;
	
	/**
	 * Inititialisation 
	 */
	function init(){
		
		// On parcours les produits associés
		$('.associatedProduct').each(function(){
			// Réduction du titre
			// Récupération du titre
			var title = $(this).find('.productTitle');
			
			dotify(title, 2);

			
			// Réduction du texte
			// Récupération du texte
			var text = $(this).find('.productDescription');
			
			dotify(text, 4);
		});
		
		// ARROW CHANGE ZOOM : Récupération des data-zoom
		$('.overviewSelected .slide .zoomOnClick').each(function(){
			zoomedOverview.push($(this).data('zoom'));
		});
		
		
		// PRODUCT MENU : Récupération du menu et de son offset
		var productMenu = new FixedMenu('#productMenu', 40);
		
		// SLIDESHOW : Initialisation du slideshow et des thumbs
		var slideshow = new ClassicSlideshow('#slideshow', {
			autoStart: false,
			index: 1,
			opacityAnimation : true,
			transitionDuration: 500
		});

		var selector = new ThumbsSelector('#slideshow .thumbsContainer', {
			intro: false,
			index: 1,
			alpha : true,
		});
		
		
		// Ecouter les changements de slide sur le slideshow
		slideshow.onChange = function (pIndex){
			// Appliquer sur le selecteur et sur l'autre slideshow
			selector.select(pIndex);
		};

		// Ecouter les changements de slide sur le selecteur
		selector.onChange = function (pIndex){
			// Appliquer sur les slideshow
			slideshow.select(pIndex);
			
			var thumbs = $('.thumbsContainer .thumb');
			thumbs.each(function(i){
				$(this).css({
					opacity: pIndex-1 == i ? 1 : 0.5
				});
			});
		};
		
		// DESCRIPTION ELLIPSIS : Ellipse de la description du produit pour tous les navigateurs
		var textContainer = $('.productCaracteristiquesPosition');
		var text = $('.productCaracteristiquesPosition .productCaracteristiques');

		var lineHeight = parseInt(text.css('line-height').replace('px', ''));
		var divHeight = text.height();
		var nbLines = divHeight / lineHeight;
		
		if(nbLines > 7){
			var fixedHeight = 7 * lineHeight;
			textContainer.css('height',fixedHeight);
			$('.productCaracteristiquesPosition').dotdotdot({
				ellipsis : '...',
				wrap : 'word', 
				height: fixedHeight+'px',
				after: '.productDescription .arrowLink'
			});
		}else{
			$('.productDescription .arrowLink').css('display', 'none');
		}
		
		// OVERVIEW TOOLTIP : Initialise les tooltips
		if($('#content').hasClass('MarketPro')){
			$('.tooltip').tooltip({
				cls: 'labelPro'
			});
		} else{
			$('.tooltip').tooltip();
		}
		
		// MINI OVERVIEW :  Initialisation du nombre de rangée de thumb
		thumbRange = Math.ceil($('.miniOverviewContainer ul li.thumb').length / 4);
		miniOverviewContainerHeight = $('.miniOverviewContainer ul').height();
		
		// POPIN ACHETER EN LIGNE
		// On initialise le lancement de la colorbox
		$('.popinBuyOnline').colorbox({
			href:"./popin-buyonline.html",
			overlayClose : true, 
			closeButton : false,
			onComplete : function(){
				$('.cross').click(function(){
					$.colorbox.close();
				});
				
				// Si on est sur iOS 
				if ( navigator.userAgent.match(/(iPad|iPhone|iPod)/g)){
					// On ajoute la classe au container
					$('#colorbox').addClass('ios');
				} 
			}
		});

		// taille thumbsnail
		thumbContainerHeight = $('.miniOverviewContainer .thumbsContainer').height();
		thumbHeight = (thumbContainerHeight / 4) - 5;
		$('.miniOverviewContainer ul li.thumb').height(thumbHeight);
		$('.miniOverviewContainer ul li.thumb').width(59);

	}
	
	/**
	 * Fonction regroupant tous les listeners
	 */
	function listener(){
		
		// BACK TO THE TOP : Listener sur le bouton back to top
		$('.backToTop a').click(function(){
			$body.stop().animate({scrollTop: '0px'}, 800);
		});
		
		// DESCRIPTION ELLIPSIS  : Clic sur le "Lire la suite" de la description produit
		$('.productDescription .arrowLink').click(function(event){
			
			// Annuler la propagation de l'event (gère IE)
			event.preventDefault ? event.preventDefault() : event.returnValue = false;
			
			// Récupération du container et du texte qu'il contient
			var container = $('.productCaracteristiquesPosition');
			var text = container.find('p');
			var link = $(this);
			
			// On récupère le contenu précédemment cut
			container.trigger("originalContent", function(content) {
				// On vide et on append tout le contenu
				text.html('');
				text.append(content);
			});
			
			// Récupération de la nouvelle height 
			var height = text.height();

			
			// Animation de la nouvelle taille du texte
			$('.productCaracteristiquesPosition').stop().animate({
				height : height
			}, 500, function(){
					// Indiquer que le body à changer de taille
					$('body').trigger('heightChange');
			});
			
			// Disparition du lien 'Lire la suite'
			link.stop().animate({
				opacity : 0
			}, 200, function(){
				link.css('display','none');
			});
		});

		// ZOOM : Click sur l'image pour déclencher le zoom
		$('.zoomOnClick').on('click', thumbOnClick);
		$('.zoomContainer').on('click', hideZoom);
		
		// MINI OVERVIEW SLIDER
		$('.miniOverviewContainer .thumbTop').click(function(){
			if(currentRange > 1){
				var marginTop = parseInt($('.miniOverviewContainer ul li.thumb').first().css('margin-top').replace('px',''));
				$('.miniOverviewContainer ul li.thumb').first().stop().animate({
					marginTop :  marginTop + miniOverviewContainerHeight
				}, 400);
				currentRange--;
			}
		});
		
		$('.miniOverviewContainer .thumbBottom').click(function(){
			if(currentRange < thumbRange){
				var marginTop = parseInt($('.miniOverviewContainer ul li.thumb').first().css('margin-top').replace('px',''));
				console.log(marginTop);
				$('.miniOverviewContainer ul li.thumb').first().stop().animate({
					marginTop : marginTop -miniOverviewContainerHeight
				}, 400);
				currentRange++;
			}
		});
	}
	
	
	/**
	 * Thumb on click
	 */
	function thumbOnClick(event){
		// On récupère l'élément sur lequel on a cliqué et son image de zoom
		var $image = $(this);
		var zoomedImageSource = $image.attr('data-zoom'); 
		
		showZoom(zoomedImageSource);
	}
	
	
	/**
	 * Show zoom
	 * @param Image à afficher
	 */
	function showZoom(zoomedImageSource){
		var $zoomContainer = $('.zoomContainer'); 
		
		// Event Resize
		$(window).bind('resize', windowResizeHandler);
		$(window).bind('orientationchange', windowResizeHandler);
		
		// Overflow body
		$('body').css({'overflow':'hidden'});
		$('.touch body').on('touchmove', touchBodyTouchMove);
		
		
		// Cache les éléments en hideOnZoom
		$('.hideOnZoom').stop().animate({
			'opacity':0
		},animateDelay);
		
		// Prepare le zoom à s'afficher
		$zoomContainer.css({
			'opacity':0,
			'display': 'block'
		});
		
		// Positionne le zoom
		positionZoom();
		
		// Affiche le zoom
		$zoomContainer.stop().animate({
			'opacity':1
		}, {duration: animateDelay});

		
		// Charge l'image
		loadImage(zoomedImageSource);
		
		// Récupération de l'index de l'image courante
		var index = $.inArray(zoomedImageSource, zoomedOverview);
		
		// BINDING KEY EVENT : Flèche gauche ou droite
		$(document).keydown(function(e){
			if (e.keyCode == 37 && index-1 >= 0) { 
				index--;
				changeImage(index);
				
			}
		    if (e.keyCode == 39 && index+1 <= zoomedOverview.length-1) { 
		    	index++;
		    	changeImage(index);
		    }
		});
	}
	
	function changeImage(index){
		$('#scroller').empty();
		loadImage(zoomedOverview[index]);
	}
	
	/**
	 * .Touch body : on touch
	 */
	function touchBodyTouchMove(event){
		event.preventDefault();
	}
	
	/**
	 * Load image
	 */
	function loadImage(zoomedImageSource){
		var $zoomContainer = $('.zoomContainer'); 
		console.log('ON CHARGE');
		$('<img />').attr('data-tooltip','ZOOM -').attr('src', zoomedImageSource).load(function(){
			$img = $(this);
			$zoomContainer.find('.scroller').append($img);
			$zoomContainer.css('height', '100%');
			if($('#content').hasClass('MarketPro')){
				$img.tooltip({
					cls: 'labelPro'
				});
			} else{
				$img.tooltip();
			}
			
			imageHeight = $img.height();
			// Si tablette 
			if( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
				$img.addClass('tablet');
			}
			
			
			if(Modernizr.touch){
				zoomContainerIscroll = new iScroll('zoomContainer',{vScrollbar: false});
			} else {
				$zoomContainer.bind('mousemove', mousemoveHandler);
			}
			
			centerImage();
		});
	}
	
	/**
	 * Hide zoom
	 */
	function hideZoom(){
		var $zoomContainer = $('.zoomContainer'); 
		
		// Off Event resize
		$(window).unbind('resize', windowResizeHandler);
		$(window).unbind('orientationchange', windowResizeHandler);
		
		if(zoomContainerIscroll != false) zoomContainerIscroll.destroy();
		
		$zoomContainer.find('.scroller img').remove();
		
		// Cache le zoom
		$zoomContainer.stop().animate({
			'opacity':0,
			'height': 0
		}, (animateDelay/2),function(){
			$(this).hide();
			
			// Body overflow
			$('body').css({'overflow':'auto'});
		});

		// Affiche les elements qui étaient cachés
		$('.hideOnZoom').stop().animate({
			'opacity':1
		},(animateDelay/2));
		
		$('.touch body').off('touchmove', touchBodyTouchMove);
	}
	
	
	/**
	 * Positionne les containeur du zoom
	 */
	function positionZoom(){
		// Scrool top
		var documentBody = document.documentElement;
		$(documentBody).animate({scrollTop: 0}, 0);
		
		var $zoomContainer = $('.zoomContainer'); 
		zoomContainerY = $zoomContainer.offset().top;
		
		var windowHeight = window.innerHeight || $(window).height();
		zoomContainerHeight = windowHeight - zoomContainerY;
		$zoomContainer.css({height:zoomContainerHeight+'px'});

		// Refresh Iscroll
		if(zoomContainerIscroll != false){
			zoomContainerIscroll.refresh();
		}
	}
	
	
	/**
	 * Window Resize Handler
	 */
	function windowResizeHandler(){
		if(windowResizeTimer) window.clearTimeout(windowResizeTimer);
		windowResizeTimer = window.setTimeout(positionZoom, 250);
	}
	
	
	/**
	 * Mouse move handler
	 */
	function mousemoveHandler(event){
		// Image plus grande que le container
		if(imageHeight >= zoomContainerHeight){
			
			// Marges
			var margin = zoomContainerHeight * 0.25;
			
			// Ratio entre 0 et 1
			var ratioY = ((event.pageY - zoomContainerY) - margin) / (zoomContainerHeight - (2 * margin));
			
			// Position top
			var imageTop = (zoomContainerHeight - imageHeight) * ratioY;
		
			
			$img.css({
				top : imageTop,
				'margin-top' : 0
			});
			
		}
		// Image plus petite que le container
		else {
			centerImage();
		}
	}

	/**
	 * Center image
	 */
	function centerImage(){
		var zoomContainerHeight = $('.zoomContainer').height();
		
		// Centrer horizontalement
		var marginLeft = ($('.zoomContainer .scroller img').width()) / 2;
		var marginLeftTablet = ($('.zoomContainer .scroller img').width()) / 20;
		$img.css({
			'margin-left' : -marginLeft+'px'
		});
		$('.tablet').css({
			'margin-left' : -marginLeftTablet+'px',
			'max-width' : 980+'px'
		});
		
		if(imageHeight < zoomContainerHeight){
			var imageTop = (zoomContainerHeight - imageHeight) / 2;
				
			if(zoomContainerIscroll != false){
				$img.css({
					'margin-top' : imageTop+'px'
				});
			} else {
				$img.css({
					top : imageTop,
					'margin-top' :0
				});
			}
		} else {
			$img.css({
				'margin-top' :0,
				'top' :0
			});
			
		}
		
	}
	
	function dotify(element, lines){
    	// Réduction du texte
		// Line height du text
		var lineHeight = parseInt(element.css('line-height'), 10);
		if(isNaN(lineHeight)){
			console.log('Line-height non fixé');
		}
		// Hauteur de la div
		var divHeight = element.height();
		// Nombre de lignes résultant
		var nbLines = divHeight / lineHeight;
			
		// Heiht à fixer
		var fixedHeight = lines * lineHeight;
		// On dotdotdot
		element.css('height', fixedHeight);
		element.dotdotdot({
			ellipsis : '...',
			wrap : 'word', 
			height: fixedHeight+'px',
		});
    	
    }
	
	/**
	 * Lancement de l'initialisation
	 */
	init();
	
	/**
	 * Lancer les listener
	 */
	listener();
	
};