/**
 * Le controller des categories
 */
petzl.controllers.Category = function ()
{
	/**
	 * Cibler ce controller
	 */
	var that = this;
	
	var RadioHandler = petzl.views.RadioHandler;
	
	function init(){
		
		var radio = new RadioHandler('.productContainer .product', '.productContainer', {
			handleBreadcrumb : true,
			callback : linkedTextHandler
			//elementToResize : '.categoryContainer'
		});
		
		
		// On initialise le lancement de la colorbox
		$('.colorbox_popup').colorbox({
			
			inline:true, 
			onComplete : function(){
				 $('#cboxClose').remove();
				$.colorbox.resize();
				$('.cross').click(function(){
					$.colorbox.close();
				});
				if ( navigator.userAgent.match(/(iPad|iPhone|iPod)/g)){
					// On ajoute la classe au container
					$('#colorbox').addClass('ios');
				} 
			}
		});
		
		var nbLinesForTitle = 2;
		var nbLinesForText = 4;
		

		// On parcours 
		$('.product').each(function(){
			// Si y'a besoin de dotify on le fait
			if(getNbLines($(this).find('.productTitle')) > nbLinesForTitle){
				dotify($(this).find('.productTitle'), nbLinesForTitle);
			} 

			if(getNbLines($(this).find('.productDescription')) > nbLinesForText){
				dotify($(this).find('.productDescription'), nbLinesForText);
			}
		});
	}
	
	function addUrlHash(){
		var subCategoryName = $('.radioContainer .radio.selected').attr('data-name'); 
		window.location.hash = '#' + subCategoryName;
	}
	
	
	function initSelectedSubCategory(){
		var hashValue = window.location.hash;
		if(hashValue != null && hashValue.indexOf('#') >= 0){
			hashValue = hashValue.substring(hashValue.indexOf('#') + 1);
		}
		$('.radioContainer .radio[data-name="'+hashValue+'"]').each(function(index,elem){
			$(elem).click();
		});
	} 
	
	/**
	 * Gère le changement de text selon le clique sur un bouton radio
	 */
	function linkedTextHandler(triVal){
		addUrlHash();
		var current  = $('.categoryDescriptionContainer .currentCategory');
		
		if($('.categoryDescriptionContainer .'+triVal)[0] != current[0]){
			// Si la catégorie n'est pas 'all'
			if(current.length > 0){
				// On enlève l'ancienne description
				current.removeClass('currentCategory').animate({
					opacity : 0
				}, 500, function(){
					$(this).css('display','none');
					
					// Si on passe d'une autre catégorie à 'all'
					if(triVal == 'all'){
						$('.categoryDescriptionContainer').addClass('all');
						$('.productContainer').addClass('all');
						$('.product').removeClass('productEnlarged');
					} 
					
					// On affiche la bonne description
					$('.categoryDescriptionContainer .'+triVal).addClass('currentCategory').css('display','block').animate({
						opacity : 1
					} , 500);
				});
			}
			// Si on passe de 'all' à une autre catégorie
			else{
				// Description choisi
				var description = $('.categoryDescriptionContainer .'+triVal);
				
				// On fait apparaitre la colonne de description
				$(description.parent()).removeClass('all');
				$('.productContainer').removeClass('all');
				$('.product').addClass('productEnlarged');
				
				// On anime l'aparition de la description
				description.addClass('currentCategory').css('display','block').animate({
					opacity : 1
				} , 1000);
				
			}
		}
	}
	/**
	 *  Retourne le nombre de lignes de l'élément
	 */
	function getNbLines(element){
		var height = element.height();
		var lineHeight = parseInt(element.css('line-height'), 10);
		return height / lineHeight;
	}

	function dotify(element, lines){
    	// Réduction du texte
		// Line height du text
		var lineHeight = parseInt(element.css('line-height'), 10);
		if(isNaN(lineHeight)){
			
		}
		// Hauteur de la div
		var divHeight = element.height();
		// Nombre de lignes résultant
		var nbLines = divHeight / lineHeight;
			
		// Heiht à fixer
		var fixedHeight = lines * lineHeight;
		// On dotdotdot
		element.css('height', fixedHeight);
		element.dotdotdot({
			ellipsis : '...',
			wrap : 'word', 
			height: fixedHeight+'px',
		});
    	
    }
	
	/**
	 * Initialisation
	 */
	init();
	
	setTimeout(function(){initSelectedSubCategory();},100);
};


	
	