﻿petzl.views.FixedMenu = function (menuSelector)
{
	var menu = $(menuSelector);
	var offset = null;
	var blockOffset = [];
	var elementOnTheTop = $(menu.prev()[0].className);
	
	function init(){
		if( /iPhone|iPad|iPod/i.test(navigator.userAgent) ) {
			menu.addClass('iDevice');
		}
		
		// PRODUCT MENU LINK : Listener sur le product menu
		menu.find('ul li').click(function(){
			
			// ID sur lequel scroller
			var div = $('#'+$(this).attr('data-id'));

			// Récupération de l'offset de la div lié au data-id
			var offset = div.offset();
			
			//Scroll sur la position de la div moins la taille du menu fixe
			var scrollTo = offset.top  - menu.height() - div.css("margin-top").replace("px", "") - $('#headerBottom').innerHeight();
			if(!$('#productMenu').hasClass('fixed')){
				scrollTo -= menu.height();
			}
			
			$('body, html').stop().animate({
				scrollTop: scrollTo
			}, 800);
		
		});
		
		/**
		 * Mettre à jour la position des blocks et du menu
		 */
		var updateBlocksPosition = function(){
			offset = menu.offset();
			
			// Vider la liste
			blockOffset = [];
			
			// Récupération des offsets des productBlock (liés au menu)
			$('.blockMenu').each(function(){
				var top = $(this).offset().top;
				var bottom = top + $(this).height();
				blockOffset[$(this).attr('id')] = {'top' : top, 'bottom':bottom};
			});
		};
		
		// Mettre à jour l'offset du menu et des blocks lorsque la hauteur du body change
		$('body').on('heightChange', updateBlocksPosition);
		
		// Récuperer une première fois la position des blocks
		updateBlocksPosition();
		
	};
	

	/**
	 * On scroll : Gérer la classe selected sur les élements du menu
	 */
	onScrollManageSelected = _.debounce(function() {
		// Quand on est fixed on check si on passe un nouveau cap
		for(var productBlock in blockOffset){

			currentScrollTop = $(window).scrollTop() + menu.height() + 100;
			// Si on est entre le top et le bottom d'un block et qu'on était pas déjà dessus auparavant
			if(currentScrollTop >= blockOffset[productBlock].top - menu.height() - $('#headerBottom').innerHeight()
				&& currentScrollTop < blockOffset[productBlock].bottom + menu.height() + $('#headerBottom').innerHeight()
				&& productBlock != menu.find('.selected').data('id')){
					// Gestion du selected
					menu.find('.selected').removeClass('selected');
					menu.find("li[data-id='"+productBlock+"']").addClass('selected');
			}
		}
		
	},40);
	
	/**
	 * On scroll : Changer la classe fixed sur le productMenu
	 */
	onScrollManageFixed = function() {
		var lastBlockMarginBottom = elementOnTheTop.css('margin-bottom');
		
		// Toggler pour le test du offset
		var isFixed = (offset.top < $(window).scrollTop()+40);
		
		// Fixe le menu ou l'enlève selon le toggler
		menu.toggleClass('fixed', isFixed);
		
				
		if(isFixed){
			elementOnTheTop.css({marginBottom: lastBlockMarginBottom + menu.height()});
		} else {
			elementOnTheTop.css({marginBottom: lastBlockMarginBottom});
		}
		
		// On indique qu'on fixe le product menu
		fixed = isFixed;
	};
	
	
	$(function(){
		//Initialisation
		init();
		
		// Listening sur le scroll pour fixer le menu
		$(window).scroll(onScrollManageSelected);
		$(window).scroll(onScrollManageFixed);
	});
};