/**
 * Le controller des categories
 */
petzl.controllers.Event = function ()
{
	
	var RadioHandler = petzl.views.RadioHandler;
	
	/**
	 * EVENT OVERVIEW
	 */
	function overview(){
		// Séparateur à ajouter
		var separator = "<div class=\"lineSeparator\"></div>";
		
		// Si on est sur la bonne page
		if($('.radioContainer').length){
			
			
			var radio = new RadioHandler('.eventsContainer .event', '.eventOverviewContainer', {
				generalRecurrence : '4n',
				marginValue : '0%',
				handleBreadcrumb : true, 
				callback : function(trival){
					// On cache le container des events
					$('.eventsContainer').stop().animate({
						opacity : 0
					}, function(){
						if(trival == 'all'){
							// On montre tout
							$('.monthContainer').show().addClass('showed');
							$('.event').show().addClass('showed');
						}else{
							// On cache tout
							$('.monthContainer').hide();
							$('.event').hide();
							$('.showed').removeClass('showed');
							$('.lineSeparator').remove();
						
							// Pour chaque mots clé
							// On montre les évenements qui ont le mot clé ainsi que le mois qui les contient
							$('.event.'+trival).show().addClass('showed');
							$('.monthContainer:has(.eventInnerContainer .'+trival+')').show().addClass('showed');
						}
						// Pour chaque mois montré
						$('.monthContainer.showed').each(function(){
							// On récupère la taille des events montré
							var length = $(this).find('.eventInnerContainer .showed').length;
							// On parcours les events de ce mois
							$(this).find('.eventInnerContainer .showed').each(function(index){
								// Si on est au bon point pour ajouter un séparateur
								if((index+1)%4 == 0 && index!=0 && length-1 != index){
									// On l'ajoute
									$(this).after(separator);
								}
								// Si on est au bon endroit pour virer les espaces à gauche
								if(index%4==0){
									// On les vire 
									$(this).css({
										borderLeft : 'none',
										paddingLeft : '0px',
										marginLeft : '0px',
									});
								}else{
									// Sinon on leur mets les propriétés normales
									$(this).css({
										borderLeft : '1px solid #bebebe',
										paddingLeft : '1.33%',
										marginLeft : '2.33%',
									});
								}
							});
						});
						// On show la totale
						$(this).stop().animate({
							opacity : 1
						});
					});
				}
			});
		}
	}
	
	/**
	 * EVENT DETAIL
	 */
	function detail(){
		// Si on a bien un container de map  
		if($('#map').length){
			var latitude = $('.latitude').text();
			var longitude =$('.longitude').text();
			
			// Initialisation des options de la map
			var mapOptions = {
					center: new google.maps.LatLng(latitude,longitude),
					zoom: 12,
					panControl: false,
					zoomControl: false,
					scaleControl: false,
					streetViewControl: false,
					overviewMapControl: false,
					mapTypeControl: false,
					mapTypeId: google.maps.MapTypeId.ROADMAP
			};
			
			// Initialisation de la mp
			var map = new google.maps.Map(document.getElementById("map"),
				mapOptions
			);
			
			// Contenu type d'une info window
			var eventName = $('#eventName').text();
			var eventActivity = $('#eventActivity').text();
			var startDate = $('#startDate').text();
			var endDate = $('#endDate').text();
			var from = $('#from').text();
			var au = $('#au').text();
			
			var contentString = '<div class="infoWindow"><p class="eventName">'+eventName+'</p>'+
			'<p class="categories"><span>'+eventActivity+'</span><br/>'+
				from +' '+ startDate+' '+ au + ' '+endDate+
			'</p></div>';
			
			// Initialisation de l'info window
			var infowindow = new google.maps.InfoWindow({
				content: contentString,
				 maxWidth: 500,
				 maxHeight : 300
			});
			
			// Initialisation d'un marker
			var marker = new google.maps.Marker({
				position: new google.maps.LatLng(latitude,longitude),
				map: map,
				icon : $('#iconPath').text(),
				title: $('#titleMap').text()
			});
			
			// On set le marker à la map
			marker.setMap(map);
			
			// On link l'info window au marker
			google.maps.event.addListener(marker, 'click', function() {
				infowindow.open(map,marker);
			});
		}
	}
	
	/**
	 * Page overview
	 */
	overview();
	
	/**
	 * Page detail
	 */
	detail();
};